/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.testkit.beans.AuditEntryBean;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.sql.Timestamp;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@Path(value="auditing")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AuditingBackdoor {
    private static String ENTITY_NAME = "AuditLog";
    private static String ITEMS_ENTITY_NAME = "AuditItem";
    private static String CHANGED_VALUES_ENTITY_NAME = "AuditChangedValue";
    private final OfBizDelegator ofBizDelegator;
    private final AuditingManager auditingManager;

    public AuditingBackdoor(OfBizDelegator ofBizDelegator, AuditingManager auditingManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.auditingManager = auditingManager;
    }

    @GET
    @Path(value="clearAll")
    public Response clearAll() {
        List records = this.ofBizDelegator.findAll(ENTITY_NAME);
        if (records != null) {
            for (GenericValue record : records) {
                this.ofBizDelegator.removeRelated("Child" + ITEMS_ENTITY_NAME, record);
                this.ofBizDelegator.removeRelated("Child" + CHANGED_VALUES_ENTITY_NAME, record);
                this.ofBizDelegator.removeValue(record);
            }
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="moveAllRecordsBackInTime")
    public Response moveAllRecordsBackInTime(@QueryParam(value="secondsIntoPast") Long secondsIntoPast) throws GenericEntityException {
        List records = this.ofBizDelegator.findAll(ENTITY_NAME);
        for (GenericValue record : records) {
            record.set("created", (Object)new Timestamp(record.getTimestamp("created").getTime() - secondsIntoPast * 1000L));
            record.store();
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="addEntry")
    public Response addEntry(AuditEntryBean entry) {
        RecordRequest recordRequest = new RecordRequest(entry.category, entry.summaryI18nKey, entry.eventSource, entry.author, entry.remoteAddress, entry.description).forObject(AssociatedItem.Type.LICENSE, "dummy");
        this.auditingManager.store(recordRequest);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }
}

