/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.config.item.SettableOptionsConfigItem;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItem;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.testkit.beans.CustomFieldConfig;
import com.atlassian.jira.testkit.beans.CustomFieldOption;
import com.atlassian.jira.testkit.beans.CustomFieldRequest;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.ofbiz.core.entity.GenericEntityException;

@Path(value="customFields")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomFieldsBackdoor {
    private final CustomFieldManager customFieldManager;
    private final ConstantsManager manager;

    public CustomFieldsBackdoor(CustomFieldManager customFieldManager, ConstantsManager manager) {
        this.customFieldManager = customFieldManager;
        this.manager = manager;
    }

    @POST
    @AnonymousAllowed
    @Path(value="create")
    public Response createCustomField(final CustomFieldRequest field) {
        CustomFieldType type = this.customFieldManager.getCustomFieldType(field.type);
        if (type == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field type with key '" + field.type + "' does not exist")).build();
        }
        CustomFieldSearcher searcher = null;
        if (field.searcherKey != null) {
            List searchers = this.customFieldManager.getCustomFieldSearchers(type);
            try {
                searcher = (CustomFieldSearcher)Iterables.find((Iterable)searchers, (Predicate)new Predicate<CustomFieldSearcher>(){

                    public boolean apply(CustomFieldSearcher customFieldSearcher) {
                        return field.searcherKey.equals(customFieldSearcher.getDescriptor().getCompleteKey());
                    }
                });
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Searcher with key " + field.searcherKey + " not found for type '" + field.type + "'")).build();
            }
        }
        List<JiraContextNode> contexts = Collections.singletonList(GlobalIssueContext.getInstance());
        List<Object> allTypes = Collections.singletonList(null);
        try {
            CustomField result = this.customFieldManager.createCustomField(field.name, field.description, type, searcher, contexts, allTypes);
            return Response.ok((Object)this.asResponse(result, false)).cacheControl(CacheControl.never()).build();
        }
        catch (GenericEntityException e) {
            throw new IllegalStateException("Something went really wrong", e);
        }
    }

    @PUT
    @Path(value="{id}")
    public Response updateCustomField(@PathParam(value="id") String customFieldId, final CustomFieldRequest field) {
        if (customFieldId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field id").build();
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field with id " + customFieldId + " does not exist")).build();
        }
        if (field.type != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Type cannot be changed").build();
        }
        CustomFieldSearcher searcher = null;
        if (field.searcherKey != null) {
            List searchers = this.customFieldManager.getCustomFieldSearchers(customField.getCustomFieldType());
            try {
                searcher = (CustomFieldSearcher)Iterables.find((Iterable)searchers, (Predicate)new Predicate<CustomFieldSearcher>(){

                    public boolean apply(CustomFieldSearcher customFieldSearcher) {
                        return field.searcherKey.equals(customFieldSearcher.getDescriptor().getCompleteKey());
                    }
                });
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Searcher with key " + field.searcherKey + " not found for type '" + field.type + "'")).build();
            }
        }
        this.customFieldManager.updateCustomField(customField.getIdAsLong(), field.name, field.description, searcher);
        return Response.ok().build();
    }

    @POST
    @AnonymousAllowed
    @Path(value="addOption/{id}")
    public Response addOption(@PathParam(value="id") String customFieldId, String optionValue) {
        if (customFieldId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field id").build();
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field with id " + customFieldId + " does not exist")).build();
        }
        Options options = customField.getOptions(null, GlobalIssueContext.getInstance());
        if (options != null) {
            options.addOption(options.getOptionById(null), optionValue);
        }
        return Response.ok().build();
    }

    @DELETE
    @AnonymousAllowed
    @Path(value="deleteOption/{id}")
    public Response deleteOption(@PathParam(value="id") String customFieldId, String optionValue) {
        Option toDelete;
        if (customFieldId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field id").build();
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field with id " + customFieldId + " does not exist")).build();
        }
        Options options = customField.getOptions(null, GlobalIssueContext.getInstance());
        if (options != null && (toDelete = options.getOptionForValue(optionValue, null)) != null) {
            options.removeOption(toDelete);
        }
        return Response.ok().build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="get")
    public Response getCustomFields(final @QueryParam(value="config") boolean config) {
        return Response.ok((Object)Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.customFieldManager.getCustomFieldObjects(), (Function)new Function<CustomField, Object>(){

            public CustomFieldResponse apply(CustomField input) {
                return CustomFieldsBackdoor.this.asResponse(input, config);
            }
        }))).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @AnonymousAllowed
    @Path(value="delete/{id}")
    public Response deleteCustomField(@PathParam(value="id") String customFieldId) {
        if (customFieldId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please supply custom field id").build();
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Custom field with id " + customFieldId + " does not exist")).build();
        }
        try {
            this.customFieldManager.removeCustomField(customField);
            return Response.ok().build();
        }
        catch (RemoveException e) {
            throw new IllegalStateException("Something went wrong: ", e);
        }
    }

    private CustomFieldResponse asResponse(CustomField input, boolean config) {
        CustomFieldSearcher customFieldSearcher = input.getCustomFieldSearcher();
        String searcherKey = customFieldSearcher == null ? null : customFieldSearcher.getDescriptor().getCompleteKey();
        CustomFieldResponse response = new CustomFieldResponse(input.getName(), input.getId(), input.getCustomFieldType().getKey(), input.getDescription(), searcherKey);
        if (config) {
            response.setConfig(this.getConfig(input));
        }
        return response;
    }

    private List<CustomFieldConfig> getConfig(CustomField input) {
        ArrayList config = Lists.newArrayList();
        for (FieldConfigScheme fieldConfigScheme : input.getConfigurationSchemes()) {
            FieldConfig onlyConfig = fieldConfigScheme.getOneAndOnlyConfig();
            if (onlyConfig == null) continue;
            CustomFieldConfig bean = new CustomFieldConfig();
            bean.setProjects(this.asSet(this.getProjectNames(fieldConfigScheme.getAssociatedProjectObjects())));
            bean.setIssueTypes(this.asSet(this.getIssueTypeNames(fieldConfigScheme.getConfigs().keySet())));
            for (FieldConfigItem item : onlyConfig.getConfigItems()) {
                if (!(item.getType() instanceof SettableOptionsConfigItem)) continue;
                bean.setOptions(this.asList(this.convertOptions((Iterable<Option>)((Options)item.getConfigurationObject(null)))));
            }
            config.add(bean);
        }
        return config;
    }

    private Iterable<CustomFieldOption> convertOptions(Iterable<Option> options) {
        return Iterables.transform(options, (Function)new Function<Option, CustomFieldOption>(){

            public CustomFieldOption apply(@Nullable Option input) {
                return CustomFieldsBackdoor.this.convertOption(input);
            }
        });
    }

    private CustomFieldOption convertOption(Option option) {
        CustomFieldOption customFieldOption = new CustomFieldOption();
        customFieldOption.setId(option.getOptionId());
        customFieldOption.setName(option.getValue());
        customFieldOption.setChildren(this.asList(this.convertOptions(option.getChildOptions())));
        return customFieldOption;
    }

    private <T> List<T> asList(Iterable<? extends T> iterable) {
        return Lists.newArrayList(iterable);
    }

    private <T> Set<T> asSet(Iterable<? extends T> iterable) {
        return Sets.newHashSet(iterable);
    }

    private Iterable<String> getProjectNames(Iterable<Project> projects) {
        return Iterables.transform((Iterable)Iterables.filter(projects, (Predicate)Predicates.notNull()), (Function)new Function<Project, String>(){

            public String apply(Project input) {
                return input.getName();
            }
        });
    }

    private Iterable<String> getIssueTypeNames(Iterable<String> ids) {
        return Iterables.transform((Iterable)Iterables.filter(ids, (Predicate)Predicates.notNull()), (Function)new Function<String, String>(){

            public String apply(String input) {
                return CustomFieldsBackdoor.this.manager.getIssueTypeObject(input).getName();
            }
        });
    }
}

