/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="entityproperties/{entityType}/{entityId}/properties")
@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class EntityPropertyBackdoor {
    private final JsonEntityPropertyManager propertyManager;

    public EntityPropertyBackdoor(JsonEntityPropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    @GET
    public Response getAllProperties(@PathParam(value="entityType") String type, @PathParam(value="entityId") Long entityId) {
        List keys = this.propertyManager.findKeys(type, entityId);
        return Response.ok().entity((Object)keys).build();
    }

    @GET
    @Path(value="{propertyKey}")
    public Response getProperty(@PathParam(value="entityType") String type, @PathParam(value="entityId") Long entityId, @PathParam(value="propertyKey") String key) {
        EntityProperty entityProperty = this.propertyManager.get(type, entityId, key);
        return (Response)Option.option((Object)entityProperty).fold(Suppliers.ofInstance((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build()), (Function)new Function<EntityProperty, Response>(){

            public Response apply(EntityProperty entityProperty) {
                return Response.ok().entity((Object)entityProperty.getValue()).build();
            }
        });
    }

    @PUT
    @Path(value="{propertyKey}")
    public Response putProperty(@PathParam(value="entityType") String type, @PathParam(value="entityId") Long entityId, @PathParam(value="propertyKey") String key, String value) {
        this.propertyManager.put(type, entityId, key, value);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{propertyKey}")
    public Response deleteProperty(@PathParam(value="entityType") String type, @PathParam(value="entityId") Long entityId, @PathParam(value="propertyKey") String key) {
        this.propertyManager.delete(type, entityId, key);
        return Response.ok().build();
    }
}

