/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.testkit.plugin.MailServersBean;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="mailServers")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MailServersBackdoor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailServersBackdoor.class);
    private final MailQueue mailQueue;

    public MailServersBackdoor(MailQueue mailQueue) {
        this.mailQueue = mailQueue;
    }

    @POST
    @Path(value="smtp")
    public Response addSmtpServer(MailServersBean mailServerBean) throws MailException {
        if (MailFactory.isSendingDisabled()) {
            throw new IllegalStateException("Mail sending is disabled. Please restart your server without -Datlassian.mail.senddisabled=true.");
        }
        MailServerManager mailServerManager = MailFactory.getServerManager();
        List smtpMailServers = mailServerManager.getSmtpMailServers();
        for (SMTPMailServer smtpMailServer : smtpMailServers) {
            mailServerManager.delete(smtpMailServer.getId());
        }
        SMTPMailServerImpl mailServer = new SMTPMailServerImpl(null, mailServerBean.name, mailServerBean.description, mailServerBean.from, mailServerBean.prefix, false, MailProtocol.SMTP, mailServerBean.serverName, mailServerBean.port, mailServerBean.tls == null ? false : mailServerBean.tls, mailServerBean.username, mailServerBean.password, 10000L);
        mailServerManager.create((MailServer)mailServer);
        return Response.ok(null).build();
    }

    @POST
    @Path(value="pop")
    public Response addPopServer(MailServersBean mailServerBean) throws MailException {
        PopMailServerImpl mailServer = new PopMailServerImpl(null, mailServerBean.name, mailServerBean.description, mailServerBean.serverName, mailServerBean.username, mailServerBean.password);
        if (StringUtils.isNotBlank((String)mailServerBean.port)) {
            mailServer.setPort(mailServerBean.port);
        }
        if (StringUtils.isNotBlank((String)mailServerBean.protocol)) {
            mailServer.setMailProtocol(MailProtocol.getMailProtocol((String)mailServerBean.protocol));
        }
        MailServerManager mailServerManager = MailFactory.getServerManager();
        mailServerManager.create((MailServer)mailServer);
        return Response.ok(null).build();
    }

    @GET
    @Path(value="flush")
    public Response flushMailQueue() {
        LOGGER.info("Flushing mail Queue - currentQueueSize = {}", (Object)this.mailQueue.size());
        LOGGER.debug("Mail queue of type: {}, from classloader: {}, ", (Object)this.mailQueue.toString(), (Object)this.mailQueue.getClass().getClassLoader().toString());
        this.mailQueue.sendBufferBlocking();
        return Response.ok().build();
    }

    @GET
    @Path(value="smtpConfigured")
    public Response smtpMailConfigured() {
        MailServerManager mailServerManager;
        boolean configured = true;
        if (MailFactory.isSendingDisabled()) {
            configured = false;
        }
        if (!(mailServerManager = MailFactory.getServerManager()).isDefaultSMTPMailServerDefined()) {
            configured = false;
        }
        return Response.ok((Object)configured).build();
    }
}

