/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.beans.PermissionGrantBean;
import com.atlassian.jira.testkit.beans.PermissionHolderBean;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="permissionSchemes")
@Produces(value={"application/json"})
public class PermissionSchemesBackdoor {
    private final Logger log = LoggerFactory.getLogger(PermissionSchemesBackdoor.class);
    private final PermissionSchemeManager schemeManager;
    private final UserKeyService userKeyService;

    public PermissionSchemesBackdoor(PermissionSchemeManager schemeManager, UserKeyService userKeyService) {
        this.schemeManager = schemeManager;
        this.userKeyService = userKeyService;
    }

    @GET
    @AnonymousAllowed
    @Path(value="copyDefault")
    public Response copyDefault(@QueryParam(value="schemeName") String newSchemeName) {
        Scheme defaultScheme = this.schemeManager.getDefaultSchemeObject();
        Scheme copyScheme = this.schemeManager.copyScheme(defaultScheme);
        copyScheme.setName(newSchemeName);
        this.schemeManager.updateScheme(copyScheme);
        return Response.ok((Object)copyScheme.getId()).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="create")
    public Response create(@QueryParam(value="schemeName") String newSchemeName, @QueryParam(value="schemeDescription") String description) {
        Scheme copyScheme = this.schemeManager.createSchemeObject(newSchemeName, description);
        return Response.ok((Object)copyScheme.getId()).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="{schemeId}")
    public Response getPermissionScheme(@PathParam(value="schemeId") Long schemeId) {
        Scheme scheme = this.schemeManager.getSchemeObject(schemeId);
        if (scheme == null) {
            return Response.serverError().cacheControl(CacheControl.never()).build();
        }
        PermissionSchemeBean permissionSchemeBean = new PermissionSchemeBean(scheme.getId(), scheme.getName());
        scheme.getEntities().stream().forEach(schemeEntity -> {
            ProjectPermissionKey permissionKey = (ProjectPermissionKey)schemeEntity.getEntityTypeId();
            String type = schemeEntity.getType();
            String parameter = schemeEntity.getParameter();
            PermissionHolderBean permissionHolderBean = new PermissionHolderBean();
            permissionHolderBean.setType(type);
            permissionHolderBean.setParameter(parameter);
            PermissionGrantBean grantBean = new PermissionGrantBean();
            grantBean.setPermission(permissionKey.permissionKey());
            grantBean.setHolder(permissionHolderBean);
            permissionSchemeBean.addPermission(grantBean);
        });
        return Response.ok((Object)permissionSchemeBean).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{schemeId}")
    public Response delete(@PathParam(value="schemeId") Long schemeId) {
        try {
            this.schemeManager.deleteScheme(schemeId);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="legacy/entity/add")
    @Deprecated
    public Response addSchemeEntity(@QueryParam(value="schemeId") long schemeId, @QueryParam(value="permission") long permission, @QueryParam(value="type") String type, @QueryParam(value="parameter") String parameter) {
        try {
            GenericValue scheme = this.schemeManager.getScheme(Long.valueOf(schemeId));
            List entities = this.schemeManager.getEntities(scheme, Long.valueOf(permission), type, parameter);
            if (!entities.isEmpty()) {
                throw new IllegalStateException("PermissionScheme entity to be added already exists");
            }
            SchemeEntity entity = new SchemeEntity(type, parameter, (Object)permission);
            this.schemeManager.createSchemeEntity(scheme, entity);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="entity/add")
    public Response addSchemeEntity(@QueryParam(value="schemeId") long schemeId, @QueryParam(value="permission") String permissionKey, @QueryParam(value="type") String type, @QueryParam(value="parameter") String parameter) {
        ProjectPermissionKey permission = new ProjectPermissionKey(permissionKey);
        Collection<PermissionSchemeEntry> matchingEntries = this.getPermissionSchemeEntries(schemeId, permission, type, parameter = this.transformParameter(type, parameter));
        if (matchingEntries.isEmpty()) {
            try {
                GenericValue scheme = this.schemeManager.getScheme(Long.valueOf(schemeId));
                SchemeEntity entity = new SchemeEntity(type, parameter, (Object)permissionKey);
                this.schemeManager.createSchemeEntity(scheme, entity);
            }
            catch (GenericEntityException e) {
                this.log.error("Error adding new entry for permission scheme {0}", (Object)schemeId, (Object)e);
                return Response.serverError().entity((Object)e.getMessage()).cacheControl(CacheControl.never()).build();
            }
        } else {
            this.log.info("Attempted to add an entity which already exists; ignoring");
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="legacy/entity/remove")
    @Deprecated
    public Response removeEntity(@QueryParam(value="schemeId") long schemeId, @QueryParam(value="permission") long permission, @QueryParam(value="type") String type, @QueryParam(value="parameter") String parameter) {
        try {
            GenericValue scheme = this.schemeManager.getScheme(Long.valueOf(schemeId));
            List entities = this.schemeManager.getEntities(scheme, Long.valueOf(permission), type, parameter);
            if (entities.isEmpty()) {
                throw new IllegalStateException("PermissionScheme entity to be removed does not exist");
            }
            for (GenericValue entity : entities) {
                Long id = entity.getLong("id");
                this.schemeManager.deleteEntity(id);
            }
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="entity/remove")
    public Response removeEntity(@QueryParam(value="schemeId") long schemeId, @QueryParam(value="permission") String permissionKey, @QueryParam(value="type") String type, @QueryParam(value="parameter") String parameter) {
        ProjectPermissionKey permission = new ProjectPermissionKey(permissionKey);
        Collection<PermissionSchemeEntry> matchingEntries = this.getPermissionSchemeEntries(schemeId, permission, type, parameter = this.transformParameter(type, parameter));
        if (!matchingEntries.isEmpty()) {
            for (PermissionSchemeEntry entry : matchingEntries) {
                try {
                    this.schemeManager.deleteEntity(entry.getId());
                }
                catch (GenericEntityException e) {
                    this.log.error("Error deleting existing entry for permission scheme {0}", (Object)schemeId, (Object)e);
                    return Response.serverError().entity((Object)e.getMessage()).cacheControl(CacheControl.never()).build();
                }
            }
        } else {
            this.log.info("Attempted to remove an entity which does not exist; ignoring");
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="legacy/entity/replace")
    @Deprecated
    public Response replaceEntities(@QueryParam(value="schemeId") long schemeId, @QueryParam(value="permission") long permission, @QueryParam(value="type") String type, @QueryParam(value="parameter") String parameter) {
        try {
            GenericValue scheme = this.schemeManager.getScheme(Long.valueOf(schemeId));
            List entities = this.schemeManager.getEntities(scheme, Long.valueOf(permission));
            for (GenericValue entity : entities) {
                Long id = entity.getLong("id");
                this.schemeManager.deleteEntity(id);
            }
            SchemeEntity entity = new SchemeEntity(type, parameter, (Object)permission);
            this.schemeManager.createSchemeEntity(scheme, entity);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="entity/replace")
    public Response replaceEntities(@QueryParam(value="schemeId") long schemeId, @QueryParam(value="permission") String permissionKey, @QueryParam(value="type") String type, @QueryParam(value="parameter") String parameter) {
        parameter = this.transformParameter(type, parameter);
        ProjectPermissionKey permission = new ProjectPermissionKey(permissionKey);
        Collection<PermissionSchemeEntry> matchingEntries = this.getPermissionSchemeEntries(schemeId, permission);
        for (PermissionSchemeEntry entry : matchingEntries) {
            try {
                this.schemeManager.deleteEntity(entry.getId());
            }
            catch (GenericEntityException e) {
                this.log.error("Error deleting existing entry for permission scheme {0}", (Object)schemeId, (Object)e);
                return Response.serverError().entity((Object)e.getMessage()).cacheControl(CacheControl.never()).build();
            }
        }
        try {
            GenericValue scheme = this.schemeManager.getScheme(Long.valueOf(schemeId));
            SchemeEntity entity = new SchemeEntity(type, parameter, (Object)permissionKey);
            this.schemeManager.createSchemeEntity(scheme, entity);
        }
        catch (GenericEntityException e) {
            this.log.error("Error adding new entry for permission scheme {0}", (Object)schemeId, (Object)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(CacheControl.never()).build();
        }
        return Response.ok(null).build();
    }

    @Nullable
    private String transformParameter(@Nonnull String type, @Nullable String parameter) {
        String newParameter = this.convertUserKey(type, parameter);
        newParameter = this.fixAnyoneGroupParameter(type, newParameter);
        return newParameter;
    }

    @Nonnull
    private String convertUserKey(@Nonnull String type, @Nullable String parameter) {
        if (JiraPermissionHolderType.USER.getKey().equals(type)) {
            return this.userKeyService.getKeyForUsername(parameter);
        }
        return parameter;
    }

    @Nullable
    private String fixAnyoneGroupParameter(@Nonnull String type, @Nullable String parameter) {
        if (JiraPermissionHolderType.GROUP.getKey().equals(type) && "".equals(parameter)) {
            return null;
        }
        return parameter;
    }

    private Collection<PermissionSchemeEntry> getPermissionSchemeEntries(long schemeId, @Nonnull ProjectPermissionKey permission) {
        return this.schemeManager.getPermissionSchemeEntries(schemeId, permission);
    }

    private Collection<PermissionSchemeEntry> getPermissionSchemeEntries(long schemeId, @Nonnull ProjectPermissionKey permission, String type) {
        return this.schemeManager.getPermissionSchemeEntries(schemeId, permission, type);
    }

    private Collection<PermissionSchemeEntry> getPermissionSchemeEntries(long schemeId, @Nonnull ProjectPermissionKey permission, @Nonnull String type, @Nullable String parameter) {
        return this.getPermissionSchemeEntries(schemeId, permission, type).stream().filter(entry -> {
            if (parameter == null) {
                return entry.getParameter() == null;
            }
            return entry.getParameter() != null && entry.getParameter().equals(parameter);
        }).collect(Collectors.toList());
    }
}

