/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="plugins")
public class PluginsBackdoor {
    private final PluginController pluginController;
    private final PluginAccessor pluginAccessor;
    private final PluginSettingsFactory pluginSettingsFactory;

    public PluginsBackdoor(PluginController pluginController, PluginAccessor pluginAccessor, PluginSettingsFactory pluginSettingsFactory) {
        this.pluginController = pluginController;
        this.pluginAccessor = pluginAccessor;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @GET
    @AnonymousAllowed
    @Path(value="state")
    public Response getStatePlugin(@QueryParam(value="key") String key) {
        PluginState state = this.pluginAccessor.getPlugin(key).getPluginState();
        return Response.ok((Object)state.name()).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="disable")
    public Response disablePlugin(@QueryParam(value="key") String key) {
        this.pluginController.disablePlugin(key);
        return Response.ok().build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="enable")
    public Response enablePlugin(@QueryParam(value="key") String key) {
        this.pluginController.enablePlugins(new String[]{key});
        return Response.ok().build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="disableModule")
    public Response disablePluginModule(@QueryParam(value="key") String key) {
        this.pluginController.disablePluginModule(key);
        return Response.ok().build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="enableModule")
    public Response enablePluginModule(@QueryParam(value="key") String key) {
        this.pluginController.enablePluginModule(key);
        return Response.ok().build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="settings/{key}")
    public Response getSettings(@PathParam(value="key") String key) {
        Object value = this.pluginSettingsFactory.createGlobalSettings().get(key);
        return Response.ok((Object)value).build();
    }

    @PUT
    @AnonymousAllowed
    @Path(value="settings/{key}")
    public Response putSettings(@PathParam(value="key") String key, String value) {
        this.pluginSettingsFactory.createGlobalSettings().put(key, (Object)value);
        return Response.ok().build();
    }
}

