/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="userProfile")
public class UserProfileBackdoor {
    private final UserPreferencesManager userPreferencesManager;
    private final UserUtil userUtil;

    public UserProfileBackdoor(UserPreferencesManager userPreferencesManager, UserUtil userUtil) {
        this.userPreferencesManager = userPreferencesManager;
        this.userUtil = userUtil;
    }

    @GET
    @AnonymousAllowed
    @Path(value="notificationType/set")
    public Response addGlobalPermission(@QueryParam(value="username") String username, @QueryParam(value="format") String format) {
        ApplicationUser user = this.getUserByName(username);
        try {
            this.preferencesOf(user).setString("user.notifications.mimetype", format);
        }
        catch (AtlassianCoreException e) {
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @PUT
    @AnonymousAllowed
    @Path(value="timeZone")
    public Response setTimeZone(@QueryParam(value="username") String username, @QueryParam(value="timeZone") String timeZone) {
        ApplicationUser user = this.getUserByName(username);
        try {
            this.preferencesOf(user).setString("jira.user.timezone", timeZone);
        }
        catch (AtlassianCoreException e) {
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @PUT
    @Path(value="preference/{name}")
    @Consumes(value={"text/plain"})
    public void setUserPreference(@QueryParam(value="username") String username, @PathParam(value="name") String name, @QueryParam(value="type") String type, String value) throws AtlassianCoreException {
        ApplicationUser user = this.getUserByName(username);
        if ("boolean".equalsIgnoreCase(type)) {
            this.preferencesOf(user).setBoolean(name, Boolean.valueOf(value).booleanValue());
            return;
        }
        if ("long".equalsIgnoreCase(type)) {
            this.preferencesOf(user).setLong(name, Long.parseLong(value));
            return;
        }
        this.preferencesOf(user).setString(name, value != null ? value : "");
    }

    @GET
    @Path(value="preference/{name}")
    @Produces(value={"application/json"})
    public Response getUserPreference(@QueryParam(value="username") String username, @PathParam(value="name") String name, @QueryParam(value="type") String type) {
        ApplicationUser user = this.getUserByName(username);
        Object value = "boolean".equalsIgnoreCase(type) ? Boolean.valueOf(this.preferencesOf(user).getBoolean(name)) : ("long".equalsIgnoreCase(type) ? Long.valueOf(this.preferencesOf(user).getLong(name)) : this.preferencesOf(user).getString(name));
        return Response.ok((Object)value).build();
    }

    @DELETE
    @Path(value="preference/{name}")
    @Consumes(value={"text/plain"})
    public void removeUserPreference(@QueryParam(value="username") String username, @PathParam(value="name") String name) throws AtlassianCoreException {
        ApplicationUser user = this.getUserByName(username);
        this.preferencesOf(user).remove(name);
    }

    private ApplicationUser getUserByName(String username) {
        ApplicationUser user = this.userUtil.getUserByName(username);
        if (user == null) {
            throw new WebApplicationException(404);
        }
        return user;
    }

    private ExtendedPreferences preferencesOf(ApplicationUser user) {
        return this.userPreferencesManager.getExtendedPreferences(user);
    }
}

