/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin.applinks;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.testkit.beans.Screen;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="screens")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ScreensBackdoorResource {
    private final FieldScreenManager fieldScreenManager;
    private final FieldManager fieldManager;

    public ScreensBackdoorResource(FieldScreenManager fieldScreenManager, FieldManager fieldManager) {
        this.fieldScreenManager = fieldScreenManager;
        this.fieldManager = fieldManager;
    }

    private Function<FieldScreen, Screen> toScreen() {
        return new Function<FieldScreen, Screen>(){

            public Screen apply(FieldScreen input) {
                return new Screen(input.getId(), input.getName(), Iterables.transform((Iterable)input.getTabs(), (Function)ScreensBackdoorResource.this.convertToTab()));
            }
        };
    }

    private Function<FieldScreenTab, Screen.Tab> convertToTab() {
        return new Function<FieldScreenTab, Screen.Tab>(){

            public Screen.Tab apply(FieldScreenTab input) {
                Iterable filtered = Iterables.filter((Iterable)input.getFieldScreenLayoutItems(), (Predicate)new Predicate<FieldScreenLayoutItem>(){

                    public boolean apply(FieldScreenLayoutItem field) {
                        return ScreensBackdoorResource.this.fieldManager.getField(field.getFieldId()) != null;
                    }
                });
                Iterable fields = Iterables.transform((Iterable)filtered, (Function)new Function<FieldScreenLayoutItem, com.atlassian.jira.testkit.beans.Field>(){

                    public com.atlassian.jira.testkit.beans.Field apply(FieldScreenLayoutItem input) {
                        Field field = ScreensBackdoorResource.this.fieldManager.getField(input.getFieldId());
                        return new com.atlassian.jira.testkit.beans.Field(field.getId(), field.getName());
                    }
                });
                return new Screen.Tab(input.getId(), input.getName(), fields);
            }
        };
    }

    @GET
    public Response get(@QueryParam(value="screen") String nameOrId) {
        if (nameOrId == null) {
            return ScreensBackdoorResource.ok(ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.fieldScreenManager.getFieldScreens(), this.toScreen())));
        }
        FieldScreen fieldScreen = this.getScreenByName(nameOrId);
        if (fieldScreen == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        return ScreensBackdoorResource.ok(this.toScreen().apply((Object)fieldScreen));
    }

    @GET
    @Path(value="removeField")
    public Response removeFieldFromScreen(@QueryParam(value="screen") String screen, @QueryParam(value="field") String field) {
        OrderableField navigableField = this.getFieldByName(field);
        if (navigableField != null) {
            FieldScreen fieldScreen = this.getScreenByName(screen);
            fieldScreen.removeFieldScreenLayoutItem(navigableField.getId());
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="addField")
    public Response addFieldToScreen(@QueryParam(value="screen") String screen, @QueryParam(value="tab") String tab, @QueryParam(value="field") String field, @QueryParam(value="position") String position) {
        FieldScreen fieldScreen = this.getScreenByName(screen);
        FieldScreenTab screenTab = StringUtils.isEmpty((String)tab) ? fieldScreen.getTab(0) : this.getTab(tab, fieldScreen);
        OrderableField navigableField = this.getFieldByName(field);
        if (navigableField != null) {
            if (StringUtils.isEmpty((String)position)) {
                screenTab.addFieldScreenLayoutItem(navigableField.getId());
            } else {
                screenTab.addFieldScreenLayoutItem(navigableField.getId(), Integer.valueOf(position).intValue());
            }
            screenTab.store();
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="setFieldPosition")
    public Response changeFieldPosition(@QueryParam(value="screen") String screen, @QueryParam(value="field") String field, @QueryParam(value="position") String position) {
        OrderableField navigableField = this.getFieldByName(field);
        if (navigableField != null) {
            FieldScreenLayoutItem layoutItem = this.getFieldScreenLayoutItem(this.getScreenByName(screen), navigableField.getId());
            layoutItem.getFieldScreenTab().moveFieldScreenLayoutItemToPosition(Collections.singletonMap(Integer.valueOf(position), layoutItem));
            this.fieldScreenManager.updateFieldScreenLayoutItem(layoutItem);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private OrderableField getFieldByName(String fieldName) {
        Set navigableFields = this.fieldManager.getOrderableFields();
        for (OrderableField navigableField : navigableFields) {
            if (!navigableField.getName().equals(fieldName)) continue;
            return navigableField;
        }
        return null;
    }

    private FieldScreenLayoutItem getFieldScreenLayoutItem(FieldScreen screen, String fieldId) {
        for (FieldScreenTab fieldScreenTab : screen.getTabs()) {
            FieldScreenLayoutItem fieldScreenLayoutItem = fieldScreenTab.getFieldScreenLayoutItem(fieldId);
            if (fieldScreenLayoutItem == null) continue;
            return fieldScreenLayoutItem;
        }
        return null;
    }

    @GET
    @Path(value="addTab")
    public Response addTab(@QueryParam(value="screen") String screen, @QueryParam(value="name") String name) {
        return ScreensBackdoorResource.ok(this.convertToTab().apply((Object)this.getScreenByName(screen).addTab(name)));
    }

    @GET
    @Path(value="deleteTab")
    public Response deleteTab(@QueryParam(value="screen") String screen, @QueryParam(value="name") String name) {
        FieldScreen screenByName = this.getScreenByName(screen);
        FieldScreenTab tab = this.getTab(name, screenByName);
        if (tab != null) {
            tab.remove();
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private FieldScreenTab getTab(String name, FieldScreen screen) {
        List tabs = screen.getTabs();
        for (FieldScreenTab tab : tabs) {
            if (!tab.getName().equals(name)) continue;
            return tab;
        }
        return null;
    }

    public FieldScreen getScreenByName(String name) {
        Collection fieldScreens = this.fieldScreenManager.getFieldScreens();
        for (FieldScreen fieldScreen : fieldScreens) {
            if (!fieldScreen.getName().equals(name)) continue;
            return fieldScreen;
        }
        return this.fieldScreenManager.getFieldScreen(Long.valueOf(Long.parseLong(name)));
    }

    private static Response ok(Object body) {
        return Response.ok().cacheControl(CacheControl.never()).entity(body).build();
    }
}

