/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin.workflows;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.testkit.plugin.workflows.WorkflowSchemeDataFactoryImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Iterables;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="workflowscheme")
public class WorkflowSchemesBackdoor {
    private final WorkflowSchemeManager workflowSchemeManager;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext context;
    private final WorkflowSchemeDataFactoryImpl dataFactory;

    public WorkflowSchemesBackdoor(WorkflowSchemeManager workflowSchemeManager, ProjectManager projectManager, JiraAuthenticationContext context, WorkflowSchemeDataFactoryImpl dataFactory) {
        this.workflowSchemeManager = workflowSchemeManager;
        this.projectManager = projectManager;
        this.context = context;
        this.dataFactory = dataFactory;
    }

    @GET
    @Path(value="copy")
    public Response copyWorkflowScheme(@QueryParam(value="schemeName") String schemeName, @QueryParam(value="newSchemeName") String newSchemeName) {
        Scheme defaultScheme = this.workflowSchemeManager.getSchemeObject(schemeName);
        Scheme copyScheme = this.workflowSchemeManager.copyScheme(defaultScheme);
        copyScheme.setName(newSchemeName);
        this.workflowSchemeManager.updateScheme(copyScheme);
        return Response.ok((Object)copyScheme.getId()).build();
    }

    @GET
    public Response getWorkflowScheme(@QueryParam(value="schemeName") String schemeName, @QueryParam(value="projectKey") String projectKey, @QueryParam(value="projectName") String projectName, @QueryParam(value="draft") boolean getDraft) {
        if ((schemeName = StringUtils.stripToNull((String)schemeName)) != null) {
            AssignableWorkflowScheme workflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(schemeName);
            if (workflowSchemeObj != null) {
                return this.ok((WorkflowScheme)workflowSchemeObj);
            }
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        if ((projectKey = StringUtils.stripToNull((String)projectKey)) == null) {
            if ((projectName = StringUtils.stripToNull((String)projectName)) == null) {
                return this.getAllSchemes();
            }
            return this.schemeForProject(this.projectManager.getProjectObjByName(projectName), getDraft);
        }
        return this.schemeForProject(this.projectManager.getProjectObjByKey(projectKey), getDraft);
    }

    @Path(value="{id}")
    @GET
    public Response getWorkflowScheme(@PathParam(value="id") long id) {
        AssignableWorkflowScheme workflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowSchemeObj == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        return Response.ok((Object)this.dataFactory.toData((WorkflowScheme)workflowSchemeObj)).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{id}")
    public Response updateWorkflowScheme(WorkflowSchemeData data, @PathParam(value="id") long id) {
        AssignableWorkflowScheme workflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowSchemeObj == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        AssignableWorkflowScheme scheme = this.workflowSchemeManager.updateWorkflowScheme(this.dataFactory.schemeFromData(data, workflowSchemeObj.builder()));
        return Response.ok((Object)this.dataFactory.toData((WorkflowScheme)scheme)).cacheControl(CacheControl.never()).build();
    }

    @Path(value="{id}/draft")
    @GET
    public Response getDraftWorkflowScheme(@PathParam(value="id") long id) {
        AssignableWorkflowScheme workflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowSchemeObj == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        DraftWorkflowScheme draftForParent = this.workflowSchemeManager.getDraftForParent(workflowSchemeObj);
        if (draftForParent == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        return Response.ok((Object)this.dataFactory.toData((WorkflowScheme)draftForParent)).cacheControl(CacheControl.never()).build();
    }

    @Path(value="{id}/draft")
    @PUT
    public Response createDraftScheme(@PathParam(value="id") long id) {
        AssignableWorkflowScheme workflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowSchemeObj == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        ApplicationUser user = this.context.getLoggedInUser();
        DraftWorkflowScheme draftForParent = this.workflowSchemeManager.createDraftOf(user, workflowSchemeObj);
        return Response.ok((Object)this.dataFactory.toData((WorkflowScheme)draftForParent)).cacheControl(CacheControl.never()).build();
    }

    @Path(value="{id}/draft")
    @POST
    public Response updateDraftScheme(@PathParam(value="id") long id, WorkflowSchemeData data) {
        AssignableWorkflowScheme workflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowSchemeObj == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        DraftWorkflowScheme draftForParent = this.workflowSchemeManager.getDraftForParent(workflowSchemeObj);
        if (draftForParent == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        ApplicationUser user = this.context.getLoggedInUser();
        DraftWorkflowScheme draftWorkflowScheme = this.workflowSchemeManager.updateDraftWorkflowScheme(user, this.dataFactory.draftFromData(data, draftForParent));
        return Response.ok((Object)this.dataFactory.toData((WorkflowScheme)draftWorkflowScheme)).cacheControl(CacheControl.never()).build();
    }

    @Path(value="{id}/draft")
    @DELETE
    public Response deleteDraftScheme(@PathParam(value="id") long id) {
        AssignableWorkflowScheme workflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowSchemeObj == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        DraftWorkflowScheme draftForParent = this.workflowSchemeManager.getDraftForParent(workflowSchemeObj);
        if (draftForParent == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        if (!this.workflowSchemeManager.deleteWorkflowScheme((WorkflowScheme)draftForParent)) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        return WorkflowSchemesBackdoor.ok();
    }

    @Path(value="{id}")
    @DELETE
    public Response deleteWorkflowScheme(@PathParam(value="id") long id) {
        AssignableWorkflowScheme workflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowSchemeObj == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        this.workflowSchemeManager.deleteWorkflowScheme((WorkflowScheme)workflowSchemeObj);
        return WorkflowSchemesBackdoor.ok();
    }

    @PUT
    public Response createWorkflowScheme(WorkflowSchemeData data) {
        AssignableWorkflowScheme scheme = this.workflowSchemeManager.createScheme(this.dataFactory.schemeFromData(data, this.workflowSchemeManager.assignableBuilder()));
        return Response.ok((Object)this.dataFactory.toData((WorkflowScheme)scheme)).cacheControl(CacheControl.never()).build();
    }

    private static Response fourOhfour() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
    }

    private Response schemeForProject(Project project, boolean getDraft) {
        AssignableWorkflowScheme scheme;
        if (project == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        AssignableWorkflowScheme projectScheme = this.workflowSchemeManager.getWorkflowSchemeObj(project);
        Object object = scheme = getDraft ? this.workflowSchemeManager.getDraftForParent(projectScheme) : projectScheme;
        if (scheme == null) {
            return WorkflowSchemesBackdoor.fourOhfour();
        }
        return this.ok((WorkflowScheme)scheme);
    }

    private Response ok(WorkflowScheme scheme) {
        return Response.ok((Object)this.dataFactory.toData(scheme)).cacheControl(CacheControl.never()).build();
    }

    private static Response ok() {
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private Response getAllSchemes() {
        Iterable schemeObjects = Iterables.transform((Iterable)this.workflowSchemeManager.getSchemeObjects(), this.dataFactory.fromSchemeToDataFunction());
        return Response.ok((Object)schemeObjects).cacheControl(CacheControl.never()).build();
    }
}

