/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.util.ClassUtils;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.WiredTestInfo;
import com.atlassian.maven.plugins.amps.xml.SpringXmlComponent;
import com.atlassian.maven.plugins.amps.xml.SpringXmlException;
import com.atlassian.maven.plugins.amps.xml.SpringXmlModel;
import com.atlassian.maven.plugins.amps.xml.SpringXmlRenderer;
import com.atlassian.maven.plugins.amps.xml.SpringXmlRendererFactory;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="test-jar", requiresDependencyResolution=ResolutionScope.TEST)
public class TestJarMojo
extends AbstractAmpsMojo {
    public static final String SPRING_CONTEXT_DIRECTORY = "META-INF/spring";
    public static final String WIRED_TEST_SPRING_XML_FILENAME = "wired-test-components.xml";
    public static final String WIRED_TEST_SPRING_XML_PATH = "META-INF/spring/wired-test-components.xml";
    @Parameter(property="project.build.finalName")
    private String finalName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject prj = this.getMavenContext().getProject();
        File testClassesDir = FileUtils.file(prj.getBuild().getTestOutputDirectory(), new String[0]);
        if (this.shouldBuildTestPlugin()) {
            File mf = FileUtils.file(testClassesDir, "META-INF", "MANIFEST.MF");
            if (!mf.exists()) {
                try {
                    String symbolicName = prj.getGroupId() + "." + prj.getArtifactId() + "-tests";
                    org.apache.commons.io.FileUtils.writeStringToFile((File)mf, (String)("Manifest-Version: 1.0\nBundle-SymbolicName: " + symbolicName + "\nBundle-Version: 1.0\nBundle-Name: " + this.finalName + "-tests\nDynamicImport-Package: *\nAtlassian-Plugin-Key: " + symbolicName + "\n"), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new MojoFailureException("Unable to write manifest");
                }
            }
            File pluginXml = FileUtils.file(testClassesDir, "atlassian-plugin.xml");
            File itPackageDir = FileUtils.file(testClassesDir, "it");
            if (pluginXml.exists() && itPackageDir.exists()) {
                Collection classFiles = org.apache.commons.io.FileUtils.listFiles((File)itPackageDir, (String[])new String[]{"class"}, (boolean)true);
                ArrayList sortedClassFiles = new ArrayList(classFiles);
                Collections.sort(sortedClassFiles);
                try {
                    SpringXmlModel.Builder modelBuilder = SpringXmlModel.builder();
                    for (File classFile : sortedClassFiles) {
                        String className = ClassUtils.getClassnameFromFile(classFile, prj.getBuild().getTestOutputDirectory());
                        WiredTestInfo wiredInfo = ClassUtils.getWiredTestInfo(classFile);
                        if (!wiredInfo.isWiredTest()) continue;
                        this.getLog().info((CharSequence)("found Test: " + className + ", adding to test-classes/" + WIRED_TEST_SPRING_XML_PATH + "..."));
                        String simpleClassname = StringUtils.substringAfterLast((String)className, (String)".");
                        SpringXmlComponent component = SpringXmlComponent.builder().putServiceProperty("inProductTest", "true").fullClassName(className).id(ClassnameUtil.camelCaseToDashed((String)simpleClassname).toLowerCase()).build();
                        modelBuilder.addComponent(component);
                    }
                    File springTestFile = FileUtils.file(testClassesDir, WIRED_TEST_SPRING_XML_PATH);
                    Path springDirectoryPath = springTestFile.getParentFile().toPath();
                    Files.createDirectories(springDirectoryPath, new FileAttribute[0]);
                    FileWriter writer = new FileWriter(springTestFile);
                    SpringXmlRendererFactory springXmlBuilderFactory = new SpringXmlRendererFactory();
                    SpringXmlRenderer springXmlRenderer = springXmlBuilderFactory.create();
                    springXmlRenderer.render(modelBuilder.build(), writer);
                }
                catch (SpringXmlException e) {
                    throw new MojoExecutionException("unable to generate Spring XML configuration for test classes folder", (Exception)e);
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("unable to convert test classes folder to URL", (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("unable to modify plugin.xml", (Exception)e);
                }
            }
            this.getMavenGoals().jarTests(this.finalName);
        }
    }
}

