/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.common;

import com.atlassian.plugins.codegen.util.Dom4jUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLDocumentHandler {
    private final File file;

    public XMLDocumentHandler(File file) {
        this.file = Objects.requireNonNull(file);
    }

    private static Document parseDoc(File file) throws DocumentException {
        SAXReader reader = Dom4jUtil.newSaxReader();
        reader.setMergeAdjacentText(true);
        return reader.read(file);
    }

    public static Document parse(File file) {
        try {
            return XMLDocumentHandler.parseDoc(file);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    protected Document read() throws MojoExecutionException {
        try {
            return XMLDocumentHandler.parseDoc(this.file);
        }
        catch (DocumentException e) {
            throw new MojoExecutionException("Cannot parse XML file: " + this.file.getName(), (Exception)((Object)e));
        }
    }

    protected void write(Document document) throws MojoExecutionException {
        try (FileOutputStream fos = new FileOutputStream(this.file);){
            XMLWriter writer = new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint());
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write updated XML file: " + this.file.getName(), (Exception)e);
        }
    }
}

