/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.transform.TransformConfig;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.dom4j.Document;

public class TransformValidator {
    private final Log log;
    private final File pluginDescriptor;
    private final Map<String, String> existingInstructions;
    private final String pluginTypeLabel;

    TransformValidator(TransformConfig configuration, MavenContext mavenContext, Log log) {
        this.log = log;
        this.pluginDescriptor = configuration.getPluginDescriptorFile(mavenContext);
        this.existingInstructions = configuration.getInstructions();
        this.pluginTypeLabel = configuration.getPluginTypeLabel();
    }

    public boolean canBeTransformed() throws MojoExecutionException {
        return this.doesPluginDescriptorExist() && !this.isAlreadyTransformerless() && this.isOsgiPlugin();
    }

    public boolean doesPluginDescriptorExist() {
        return this.pluginDescriptor.exists();
    }

    public void validatePluginDescriptorExists() throws MojoExecutionException {
        if (!this.doesPluginDescriptorExist()) {
            throw new MojoExecutionException("atlassian-plugin.xml not found at: " + this.pluginDescriptor.getAbsolutePath());
        }
    }

    public boolean isAlreadyTransformerless() {
        if (this.existingInstructions != null && this.existingInstructions.containsKey("Atlassian-Plugin-Key")) {
            this.log.info((CharSequence)(StringUtils.capitalize((String)this.pluginTypeLabel) + " is already transformerless (has '" + "Atlassian-Plugin-Key" + "' header), no transformerless conversion necessary."));
            return true;
        }
        return false;
    }

    public boolean isOsgiPlugin() throws MojoExecutionException {
        Document atlPluginXmlDoc;
        try {
            atlPluginXmlDoc = XMLDocumentHandler.parse(this.pluginDescriptor);
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Cannot parse plugin descriptor: " + this.pluginDescriptor.getName(), (Exception)e);
        }
        String pluginsVersion = atlPluginXmlDoc.getRootElement().attributeValue("pluginsVersion");
        if (pluginsVersion == null) {
            pluginsVersion = atlPluginXmlDoc.getRootElement().attributeValue("plugins-version");
        }
        if (pluginsVersion == null || !pluginsVersion.trim().equals("2")) {
            this.log.info((CharSequence)(StringUtils.capitalize((String)this.pluginTypeLabel) + " is not OSGi, no transformerless conversion necessary."));
            return false;
        }
        return true;
    }
}

