/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor;

import com.atlassian.maven.plugins.amps.util.ZipUtils;
import com.atlassian.maven.plugins.amps.util.manifest.ManifestDeserializer;
import com.atlassian.maven.plugins.amps.util.manifest.ManifestUtils;
import com.atlassian.maven.plugins.amps.util.manifest.ParsedManifest;
import com.atlassian.plugins.codegen.BundleInstruction;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;

public class JarExtractionService {
    public List<BundleInstruction> extractBundleInstructions(File jar) throws MojoExecutionException {
        ParsedManifest parsedManifest;
        try {
            parsedManifest = ManifestDeserializer.parseManifestFromJar(jar.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse manifest from JAR: " + jar.getAbsolutePath(), (Exception)e);
        }
        List<BundleInstruction> bundleInstructions = ManifestUtils.mapParsedManifestToBundleInstructions(parsedManifest);
        return ManifestUtils.dropInstructionVersionConstraints(bundleInstructions);
    }

    public void extractSpringContext(File transformedJar, Path projectResourcesDir) throws MojoExecutionException {
        this.ensureDirectoryExists(projectResourcesDir);
        this.extractSpringFiles(transformedJar, projectResourcesDir);
    }

    private void ensureDirectoryExists(Path directory) throws MojoExecutionException {
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to find/create resources directory: " + directory.toAbsolutePath(), (Exception)e);
        }
    }

    private void extractSpringFiles(File transformedJar, Path targetDirectory) throws MojoExecutionException {
        try {
            Pattern springPattern = Pattern.compile(Pattern.quote("META-INF/spring") + "/atlassian-plugins-.*");
            ZipUtils.unzip(transformedJar, targetDirectory.toAbsolutePath().toString(), 0, false, springPattern);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to extract META-INF/spring from transformed JAR: " + e.getMessage(), (Exception)e);
        }
    }
}

