/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor.xmltojava;

import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.JavaSourcePathUtil;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.TemplateUtil;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class GenerateJavaUtil {
    static void generateJavaFile(Path outputPath, Set<Map<String, String>> allBeanParams, String entryTemplate, String fileTemplate) throws IOException {
        GenerateJavaUtil.generateJavaFile(outputPath, allBeanParams, entryTemplate, fileTemplate, Collections.emptyList());
    }

    static void generateJavaFile(Path outputPath, Set<Map<String, String>> allBeanParams, String entryTemplate, String fileTemplate, Collection<String> additionalImports) throws IOException {
        String packageName = JavaSourcePathUtil.getQualifiedPackageFromPath(outputPath);
        Set allImports = allBeanParams.stream().map(params -> (String)params.get("qualifiedClassName")).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        allImports.addAll(additionalImports);
        String importsSection = GenerateJavaUtil.getImportsFromClassNames(allImports);
        StringBuilder entriesBuilder = new StringBuilder();
        for (Map<String, String> beanParams : allBeanParams) {
            ImmutableMap.Builder updatedBeanParams = ImmutableMap.builder().putAll(beanParams);
            String qualifiedClassName = beanParams.get("qualifiedClassName");
            if (qualifiedClassName != null) {
                updatedBeanParams.put((Object)"className", (Object)GenerateJavaUtil.getSimpleClassName(qualifiedClassName));
            }
            String beanEntry = TemplateUtil.getProcessedTemplate(entryTemplate, (Map<String, String>)updatedBeanParams.build());
            entriesBuilder.append("\n").append(beanEntry);
        }
        String entriesSection = entriesBuilder.toString();
        ImmutableMap params2 = ImmutableMap.of((Object)"packageName", (Object)packageName, (Object)"imports", (Object)importsSection, (Object)"entries", (Object)entriesSection);
        TemplateUtil.writeTemplateToPath(outputPath, fileTemplate, (Map<String, String>)params2);
    }

    static String getImportsFromClassNames(Collection<String> classNames) {
        StringBuilder importsBuilder = new StringBuilder();
        ArrayList<String> sortedClassNames = new ArrayList<String>(classNames);
        Collections.sort(sortedClassNames);
        for (String className : sortedClassNames) {
            importsBuilder.append("import ").append(className).append(";\n");
        }
        if (importsBuilder.length() > 0) {
            importsBuilder.setLength(importsBuilder.length() - 1);
        }
        return importsBuilder.toString();
    }

    static String getSpringConfigImportsFromClassNames(Collection<String> classNames) {
        return StringUtils.repeat((String)" ", (int)8) + classNames.stream().map(name -> name + ".class").collect(Collectors.joining(",\n" + StringUtils.repeat((String)" ", (int)8)));
    }

    static String getSimpleClassName(String qualifiedClassName) {
        int lastDot = qualifiedClassName.lastIndexOf(46);
        return lastDot >= 0 ? qualifiedClassName.substring(lastDot + 1) : qualifiedClassName;
    }

    static String getDefaultBeanName(String qualifiedClassName) {
        return StringUtils.uncapitalize((String)GenerateJavaUtil.getSimpleClassName(qualifiedClassName));
    }
}

