/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor.xmltojava;

import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.ComponentImportsConverter;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.ComponentsConverter;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.GenerateJavaUtil;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.HostComponentsConverter;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.IndividualConverter;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.JavaSourcePathUtil;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.ModuleTypesConverter;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.TemplateUtil;
import com.atlassian.plugins.codegen.ArtifactDependency;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class SpringXmlToJavaConverter {
    private static final String SPRING_BEANS_JAVA = "SpringBeans.java";
    private static final String SPR_BEANS_JAVA_TPLT = "SpringBeans.sub";
    private static final String BASE_SPRING_XML = "spring.xml";
    private static final String SPRING_XML_TPLT = "SpringXml.sub";
    private final Log log;
    private final List<IndividualConverter> registeredConverters = ImmutableList.of((Object)new ComponentImportsConverter(), (Object)new HostComponentsConverter(), (Object)new ComponentsConverter(), (Object)new ModuleTypesConverter());

    public SpringXmlToJavaConverter(Log log) {
        this.log = log;
    }

    public boolean convert(Path resourcesPath) throws IOException {
        Path srcPath = resourcesPath.getParent().resolve("java");
        Path springXmlDirPath = resourcesPath.resolve("META-INF/spring");
        Path defaultSpringXmlPath = springXmlDirPath.resolve(BASE_SPRING_XML);
        if (Files.exists(defaultSpringXmlPath, new LinkOption[0])) {
            this.log.info((CharSequence)("Skipping conversion to Spring Java, conflicting Spring context found at " + defaultSpringXmlPath));
            return false;
        }
        Path basePackagePath = JavaSourcePathUtil.findBasePackage(srcPath);
        Path springPackagePath = basePackagePath.resolve("spring");
        if (!JavaSourcePathUtil.isDirectoryEmpty(springPackagePath)) {
            this.log.info((CharSequence)("Skipping conversion to Spring Java, conflicting Spring package found at " + springPackagePath));
            return false;
        }
        Files.createDirectories(springPackagePath, new FileAttribute[0]);
        List<Path> createdJavaFiles = this.convertRecognisedXmlFiles(springXmlDirPath, springPackagePath);
        if (createdJavaFiles.isEmpty()) {
            this.log.info((CharSequence)"No recognised Spring XML files found for conversion");
            return false;
        }
        Path springBeansJavaFile = springPackagePath.resolve(SPRING_BEANS_JAVA);
        this.writeSpringBeansJavaFile(springBeansJavaFile, createdJavaFiles);
        this.writeSpringXmlFile(defaultSpringXmlPath, springBeansJavaFile);
        return true;
    }

    private List<Path> convertRecognisedXmlFiles(Path springXmlDirPath, Path springPackagePath) throws IOException {
        ArrayList<Path> createdJavaFiles = new ArrayList<Path>();
        for (IndividualConverter converter : this.registeredConverters) {
            Path xmlFilePath = springXmlDirPath.resolve(converter.supportedXmlFilename());
            if (!Files.exists(xmlFilePath, new LinkOption[0])) continue;
            createdJavaFiles.addAll(converter.convert(xmlFilePath, springPackagePath));
        }
        for (IndividualConverter converter : this.registeredConverters) {
            Files.deleteIfExists(springXmlDirPath.resolve(converter.supportedXmlFilename()));
        }
        return Collections.unmodifiableList(createdJavaFiles);
    }

    private void writeSpringBeansJavaFile(Path springBeansJavaFile, List<Path> createdJavaFiles) throws IOException {
        String classNamesAsString = GenerateJavaUtil.getSpringConfigImportsFromClassNames(createdJavaFiles.stream().map(JavaSourcePathUtil::getSimpleClassNameFromJavaFilePath).collect(Collectors.toList()));
        ImmutableMap params = ImmutableMap.of((Object)"packageName", (Object)JavaSourcePathUtil.getQualifiedPackageFromPath(springBeansJavaFile), (Object)"classNamesAsString", (Object)classNamesAsString);
        TemplateUtil.writeTemplateToPath(springBeansJavaFile, SPR_BEANS_JAVA_TPLT, (Map<String, String>)params);
        this.log.info((CharSequence)("Wrote Spring Java config to " + springBeansJavaFile));
    }

    private void writeSpringXmlFile(Path springXmlPath, Path springBeansJavaFile) throws IOException {
        TemplateUtil.writeTemplateToPath(springXmlPath, SPRING_XML_TPLT, (Map<String, String>)ImmutableMap.of((Object)"qualifiedClassName", (Object)JavaSourcePathUtil.getQualifiedNameFromJavaFilePath(springBeansJavaFile)));
        this.log.info((CharSequence)("Wrote Spring XML config to " + springXmlPath));
    }

    public List<ArtifactDependency> getRequiredDependencies() {
        return ImmutableList.of((Object)ArtifactDependency.dependency((String)"com.atlassian.plugins", (String)"atlassian-plugins-osgi-javaconfig", (String)"0.6.1", (ArtifactDependency.Scope)ArtifactDependency.Scope.COMPILE), (Object)ArtifactDependency.dependency((String)"com.atlassian.plugins", (String)"atlassian-plugins-osgi-bridge", (String)"7.2.9", (ArtifactDependency.Scope)ArtifactDependency.Scope.PROVIDED), (Object)ArtifactDependency.dependency((String)"com.atlassian.plugins", (String)"atlassian-plugins-osgi", (String)"7.2.9", (ArtifactDependency.Scope)ArtifactDependency.Scope.PROVIDED), (Object)ArtifactDependency.dependency((String)"org.springframework", (String)"spring-beans", (String)"5.3.39-atlassian-6", (ArtifactDependency.Scope)ArtifactDependency.Scope.PROVIDED), (Object)ArtifactDependency.dependency((String)"org.springframework", (String)"spring-context", (String)"5.3.39-atlassian-6", (ArtifactDependency.Scope)ArtifactDependency.Scope.PROVIDED), (Object)ArtifactDependency.dependency((String)"org.apache.felix", (String)"org.apache.felix.framework", (String)"7.0.5", (ArtifactDependency.Scope)ArtifactDependency.Scope.PROVIDED), (Object)ArtifactDependency.dependencyWithoutTransitives((String)"org.eclipse.gemini.blueprint", (String)"gemini-blueprint-core", (String)"3.0.0.M01", (ArtifactDependency.Scope)ArtifactDependency.Scope.PROVIDED));
    }
}

