/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.util.TestClassVisitor;
import com.atlassian.maven.plugins.amps.util.WiredTestInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassUtils {
    public static String getClassnameFromFile(File classFile, String removePrefix) {
        String regex = "/";
        if (SystemUtils.IS_OS_WINDOWS) {
            regex = "\\\\";
        }
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)StringUtils.removeStart((String)classFile.getAbsolutePath(), (String)removePrefix).replaceAll(regex, "."), (String)"."), (String)".class");
    }

    public static WiredTestInfo getWiredTestInfo(File classFile) {
        String applicationFilter;
        boolean isWiredClass;
        try (FileInputStream fis = new FileInputStream(classFile);){
            TestClassVisitor visitor = new TestClassVisitor();
            ClassReader reader = new ClassReader((InputStream)fis);
            reader.accept((ClassVisitor)visitor, 7);
            isWiredClass = visitor.isWiredTest();
            applicationFilter = visitor.getApplicationFilter();
        }
        catch (IOException e) {
            isWiredClass = false;
            applicationFilter = "";
        }
        return new WiredTestInfo(isWiredClass, applicationFilter);
    }
}

