/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.ant;

import com.atlassian.maven.plugins.amps.util.ant.AntBuildListener;
import com.atlassian.maven.plugins.amps.util.ant.AntUtils;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;

public class JavaTaskFactory {
    private final AntUtils antUtils = new AntUtils();
    private final Log logger;

    public JavaTaskFactory(Log logger) {
        this.logger = logger;
    }

    public Java newJavaTask(Parameters params) {
        Java java = (Java)this.antUtils.createAntTask("java");
        java.setFork(true);
        this.setJvm(params.jvm, java);
        this.setOutput(params.output, java);
        this.addBuildListener(java);
        this.addSystemProperties(java, params.systemProperties);
        this.addJvmArgs(java, params.jvmArgs);
        return java;
    }

    private void setOutput(String output, Java java) {
        if (output != null) {
            File outputFile = new File(output);
            outputFile.getAbsoluteFile().getParentFile().mkdirs();
            java.setOutput(outputFile);
            java.setAppend(true);
        }
    }

    private void setJvm(String jvm, Java java) {
        if (jvm != null) {
            java.setJvm(jvm);
        }
    }

    private void addBuildListener(Java java) {
        boolean foundBuildListener = false;
        for (Object listenerObject : java.getProject().getBuildListeners()) {
            if (!(listenerObject instanceof AntBuildListener)) continue;
            foundBuildListener = true;
            break;
        }
        if (!foundBuildListener) {
            java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.logger));
        }
    }

    private void addSystemProperties(Java java, Map<String, String> systemProperties) {
        for (Map.Entry<String, String> prop : systemProperties.entrySet()) {
            java.addSysproperty(this.antUtils.createSysProperty(prop.getKey(), prop.getValue()));
        }
    }

    private void addJvmArgs(Java java, String jvmArgs) {
        if (jvmArgs != null) {
            java.createJvmarg().setLine(jvmArgs);
        }
    }

    public static final class Parameters {
        private final String output;
        private final String jvm;
        private final String jvmArgs;
        private final Map<String, String> systemProperties;

        private Parameters(String output, String jvm, String jvmArgs, Map<String, String> systemProperties) {
            this.output = output;
            this.jvm = jvm;
            this.jvmArgs = jvmArgs;
            this.systemProperties = systemProperties;
        }

        public static class Builder {
            private String output;
            private String jvm;
            private String jvmArgs;
            private Map<String, String> systemProperties = Collections.emptyMap();

            public Builder output(String output) {
                this.output = output;
                return this;
            }

            public Builder jvm(String jvm) {
                this.jvm = jvm;
                return this;
            }

            public Builder jvmArgs(String jvmArgs) {
                this.jvmArgs = jvmArgs;
                return this;
            }

            public Builder systemProperties(Map<String, String> systemProperties) {
                this.systemProperties = systemProperties;
                return this;
            }

            public Parameters build() {
                return new Parameters(this.output, this.jvm, this.jvmArgs, this.systemProperties);
            }
        }
    }
}

