/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.product.manager.BaseUrlUtils;
import java.io.File;

public class InstallParams {
    private static final String UPM_ROOT_RESOURCE = "/rest/plugins/1.0/";
    private final String pluginKey;
    private final String serverUrl;
    private final String username;
    private final String password;
    private final File pluginFile;
    private final String signature;
    private final boolean useHttps;

    private InstallParams(Builder builder) {
        this.pluginKey = builder.pluginKey;
        this.serverUrl = BaseUrlUtils.getBaseUrl(builder.server, builder.port, builder.contextPath);
        this.useHttps = builder.useHttps;
        this.username = builder.username;
        this.password = builder.password;
        this.pluginFile = builder.pluginFile;
        this.signature = builder.signature;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getUpmUrl() {
        return this.serverUrl + UPM_ROOT_RESOURCE;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public File getPluginFile() {
        return this.pluginFile;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean useHttps() {
        return this.useHttps;
    }

    public static class Builder {
        private String pluginKey;
        private String server;
        private int port = 0;
        private String contextPath;
        private String username;
        private String password;
        private File pluginFile;
        private String signature;
        private boolean useHttps = false;

        public Builder pluginKey(String pluginKey) {
            this.pluginKey = pluginKey;
            return this;
        }

        public Builder server(String server) {
            this.server = server;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder useHttps(boolean useHttps) {
            this.useHttps = useHttps;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder pluginFile(File file) {
            this.pluginFile = file;
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public InstallParams build() {
            return new InstallParams(this);
        }
    }
}

