/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.Application;
import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.XmlOverride;
import com.atlassian.maven.plugins.amps.product.manager.BaseUrlUtils;
import com.atlassian.maven.plugins.amps.util.ArtifactRetriever;
import com.atlassian.maven.plugins.amps.util.MapUtils;
import com.atlassian.upm.signing.tool.UpmConfigHandler;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.Document;

public class Product {
    protected String customContainerArtifact;
    protected String containerId;
    protected boolean containerNotSpecified;
    private int httpPort = 0;
    protected int rmiPort = 0;
    private Boolean useHttps;
    private int httpsPort;
    private String httpsClientAuth;
    private String httpsSslProtocol;
    private String httpsKeystoreFile;
    private String httpsKeystorePass;
    private String httpsKeyAlias;
    private Boolean httpsHttpSecure;
    protected String contextPath;
    protected String server;
    protected String version;
    protected String resolvedVersion;
    private String jvm = "";
    protected String jvmArgs = "";
    protected String debugArgs = "";
    protected File log4jProperties;
    protected File log4j2Config;
    protected String productDataVersion;
    protected String productDataPath = "";
    protected String dataHome = "";
    protected String dataOverridesPath = "";
    private List<Application> applications = new ArrayList<Application>();
    private List<ProductArtifact> pluginArtifacts = new ArrayList<ProductArtifact>();
    private List<ProductArtifact> libArtifacts = new ArrayList<ProductArtifact>();
    private List<ProductArtifact> bundledArtifacts = new ArrayList<ProductArtifact>();
    private String salVersion;
    private String restVersion;
    private String webConsoleVersion;
    private Boolean enableAchoo;
    private String achooVersion;
    private Boolean enableDevToolbox;
    private Boolean enableWebConsole;
    private String devToolboxVersion;
    private Boolean enableQuickReload;
    private String quickReloadVersion;
    private Boolean enablePluginViewer;
    private String pluginViewerVersion;
    private Boolean enablePde;
    private String pdeVersion;
    protected String id;
    protected String instanceId;
    private ArtifactRetriever artifactRetriever;
    private Boolean installPlugin;
    private Map<String, Object> systemProperties = new HashMap<String, Object>();
    private Collection<XmlOverride> cargoXmlOverrides;
    private Consumer<Document> contextXmlModifier;
    private String output;
    private int jvmDebugPort;
    private int startupTimeout;
    private int shutdownTimeout;
    private Boolean synchronousStartup;
    private Boolean awaitFullInitialization;
    private String groupId;
    private String artifactId;
    private List<DataSource> dataSources;
    private String sharedHome;
    private int ajpPort;
    private String license;
    private List<Node> nodes;
    private UpmConfigHandler upmConfigHandler;

    public Product merge(Product product) {
        Product prod = new Product();
        prod.setOutput(this.output == null ? product.getOutput() : this.output);
        prod.setSystemPropertyVariables(MapUtils.merge(product.getSystemPropertyVariables(), this.systemProperties));
        prod.setInstallPlugin(this.installPlugin == null ? product.isInstallPlugin() : this.installPlugin);
        prod.setArtifactRetriever(this.artifactRetriever == null ? product.getArtifactRetriever() : this.artifactRetriever);
        prod.setId(this.id == null ? product.getId() : this.id);
        prod.setInstanceId(this.instanceId == null ? product.getInstanceId() : this.instanceId);
        prod.setEnableWebConsole(this.enableWebConsole == null ? product.isEnableWebConsole() : this.enableWebConsole);
        prod.setWebConsoleVersion(this.webConsoleVersion == null ? product.getWebConsoleVersion() : this.webConsoleVersion);
        prod.setEnableAchoo(this.enableAchoo == null ? product.isEnableAchoo() : this.enableAchoo);
        prod.setAchooVersion(this.achooVersion == null ? product.getAchooVersion() : this.achooVersion);
        prod.setEnableDevToolbox(this.enableDevToolbox == null ? product.isEnableDevToolbox() : this.enableDevToolbox);
        prod.setDevToolboxVersion(this.devToolboxVersion == null ? product.getDevToolboxVersion() : this.devToolboxVersion);
        prod.setEnableQuickReload(this.enableQuickReload == null ? product.isEnableQuickReload() : this.enableQuickReload);
        prod.setQuickReloadVersion(this.quickReloadVersion == null ? product.getQuickReloadVersion() : this.quickReloadVersion);
        prod.setEnablePluginViewer(this.enablePluginViewer == null ? product.isEnablePluginViewer() : this.enablePluginViewer);
        prod.setPluginViewerVersion(this.pluginViewerVersion == null ? product.getPluginViewerVersion() : this.pluginViewerVersion);
        prod.setEnablePde(this.enablePde == null ? product.isEnablePde() : this.enablePde);
        prod.setPdeVersion(this.pdeVersion == null ? product.getPdeVersion() : this.pdeVersion);
        prod.setRestVersion(this.restVersion == null ? product.getRestVersion() : this.restVersion);
        prod.setSalVersion(this.salVersion == null ? product.getSalVersion() : this.salVersion);
        prod.setBundledArtifacts(this.bundledArtifacts.isEmpty() ? product.getBundledArtifacts() : this.bundledArtifacts);
        prod.setPluginArtifacts(this.pluginArtifacts.isEmpty() ? product.getPluginArtifacts() : this.pluginArtifacts);
        prod.setLibArtifacts(this.libArtifacts.isEmpty() ? product.getLibArtifacts() : this.libArtifacts);
        prod.setApplications(this.applications.isEmpty() ? product.getApplications() : this.applications);
        prod.setDataPath(StringUtils.isBlank((CharSequence)this.productDataPath) ? product.getDataPath() : this.productDataPath);
        prod.setDataVersion(this.productDataVersion == null ? product.getDataVersion() : this.productDataVersion);
        prod.setDataHome(this.dataHome == null ? product.getDataHome() : this.dataHome);
        prod.setDataOverridesPath(this.dataOverridesPath == null ? product.getDataOverridesPath() : this.dataOverridesPath);
        prod.setLog4jProperties(this.log4jProperties == null ? product.getLog4jProperties() : this.log4jProperties);
        prod.setLog4j2Config(this.log4j2Config == null ? product.getLog4j2Config() : this.log4j2Config);
        prod.setJvm(StringUtils.stripToNull((String)this.jvm) == null ? product.getJvm() : this.jvm);
        prod.setJvmArgs(StringUtils.stripToNull((String)this.jvmArgs) == null ? product.getJvmArgs() : this.jvmArgs);
        prod.setDebugArgs(StringUtils.stripToNull((String)this.debugArgs) == null ? product.getDebugArgs() : this.debugArgs);
        prod.setDataSources(this.dataSources == null ? product.getDataSources() : this.dataSources);
        prod.setGroupId(this.groupId == null ? product.getGroupId() : this.groupId);
        prod.setArtifactId(this.artifactId == null ? product.getArtifactId() : this.artifactId);
        prod.setVersion(this.version == null ? product.getVersion() : this.version);
        prod.setResolvedVersion(this.resolvedVersion == null ? product.getResolvedVersion() : this.resolvedVersion);
        prod.setServer(this.server == null ? product.getServer() : this.server);
        prod.setContextPath(this.contextPath == null ? product.getContextPath() : this.contextPath);
        prod.setCustomContainerArtifact(this.customContainerArtifact == null ? product.getCustomContainerArtifact() : this.customContainerArtifact);
        prod.setContainerId(this.containerId == null ? product.getContainerId() : this.containerId);
        prod.setContainerNotSpecified(this.containerNotSpecified && product.isContainerNotSpecified());
        prod.setRmiPort(this.rmiPort == 0 ? product.getRmiPort() : this.rmiPort);
        prod.setHttpPort(this.httpPort == 0 ? product.getHttpPort() : this.httpPort);
        prod.setAjpPort(this.ajpPort == 0 ? product.getAjpPort() : this.ajpPort);
        prod.setJvmDebugPort(this.jvmDebugPort == 0 ? product.getJvmDebugPort() : this.jvmDebugPort);
        prod.setUseHttps(this.useHttps == null ? product.getUseHttps() : this.useHttps);
        prod.setStartupTimeout(this.startupTimeout == 0 ? product.getStartupTimeout() : this.startupTimeout);
        prod.setShutdownTimeout(this.shutdownTimeout == 0 ? product.getShutdownTimeout() : this.shutdownTimeout);
        prod.setSynchronousStartup(this.synchronousStartup == null ? product.getSynchronousStartup() : this.synchronousStartup);
        prod.setSharedHome(this.sharedHome == null ? product.getSharedHome() : this.sharedHome);
        prod.setCargoXmlOverrides(this.cargoXmlOverrides == null ? product.getCargoXmlOverrides() : this.cargoXmlOverrides);
        prod.setContextXmlModifier(this.contextXmlModifier == null ? product.getContextXmlModifier() : this.contextXmlModifier);
        prod.setHttpsPort(this.httpsPort == 0 ? product.getHttpsPort() : this.httpsPort);
        prod.setHttpsClientAuth(this.httpsClientAuth == null ? product.getHttpsClientAuth() : this.httpsClientAuth);
        prod.setHttpsSSLProtocol(this.httpsSslProtocol == null ? product.getHttpsSSLProtocol() : this.httpsSslProtocol);
        prod.setHttpsKeystoreFile(this.httpsKeystoreFile == null ? product.getHttpsKeystoreFile() : this.httpsKeystoreFile);
        prod.setHttpsKeystorePass(this.httpsKeystorePass == null ? product.getHttpsKeystorePass() : this.httpsKeystorePass);
        prod.setHttpsKeyAlias(this.httpsKeyAlias == null ? product.getHttpsKeyAlias() : this.httpsKeyAlias);
        prod.setHttpsHttpSecure(this.httpsHttpSecure == null ? product.getHttpsHttpSecure() : this.httpsHttpSecure);
        prod.setAwaitFullInitialization(this.awaitFullInitialization == null ? product.isAwaitFullInitialization() : this.awaitFullInitialization.booleanValue());
        prod.setLicense(this.license == null ? product.getLicense() : this.license);
        prod.setNodes(this.nodes == null ? product.nodes : this.nodes);
        prod.setUpmConfigHandler(this.upmConfigHandler == null ? product.upmConfigHandler : this.upmConfigHandler);
        return prod;
    }

    void setUpmConfigHandler(UpmConfigHandler upmConfigHandler) {
        this.upmConfigHandler = upmConfigHandler;
        if (upmConfigHandler != null) {
            this.getSystemPropertyVariables().putAll(upmConfigHandler.getSystemProperties());
        }
    }

    void setLicense(String license) {
        this.license = license;
    }

    public String getCustomContainerArtifact() {
        return this.customContainerArtifact;
    }

    public void setCustomContainerArtifact(String customContainerArtifact) {
        this.customContainerArtifact = customContainerArtifact;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    int getHttpPort() {
        return this.httpPort;
    }

    void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    @VisibleForTesting
    int getRmiPort() {
        return this.rmiPort;
    }

    void setRmiPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public int getTimeout(boolean startingUp) {
        return startingUp ? this.startupTimeout : this.shutdownTimeout;
    }

    public Boolean getUseHttps() {
        return this.useHttps;
    }

    public void setUseHttps(Boolean useHttps) {
        this.useHttps = useHttps;
    }

    void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsClientAuth(String httpsClientAuth) {
        this.httpsClientAuth = httpsClientAuth;
    }

    public String getHttpsClientAuth() {
        return this.httpsClientAuth;
    }

    public void setHttpsSSLProtocol(String httpsSslProtocol) {
        this.httpsSslProtocol = httpsSslProtocol;
    }

    public String getHttpsSSLProtocol() {
        return this.httpsSslProtocol;
    }

    public void setHttpsKeystoreFile(String httpsKeystoreFile) {
        this.httpsKeystoreFile = httpsKeystoreFile;
    }

    public String getHttpsKeystoreFile() {
        return this.httpsKeystoreFile;
    }

    public void setHttpsKeystorePass(String httpsKeystorePass) {
        this.httpsKeystorePass = httpsKeystorePass;
    }

    public String getHttpsKeystorePass() {
        return this.httpsKeystorePass;
    }

    public void setHttpsKeyAlias(String httpsKeyAlias) {
        this.httpsKeyAlias = httpsKeyAlias;
    }

    public String getHttpsKeyAlias() {
        return this.httpsKeyAlias;
    }

    public void setHttpsHttpSecure(Boolean httpsHttpSecure) {
        this.httpsHttpSecure = httpsHttpSecure;
    }

    public Boolean getHttpsHttpSecure() {
        return this.httpsHttpSecure;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = StringUtils.defaultString((String)jvm);
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = StringUtils.defaultString((String)jvmArgs);
    }

    public void defaultJvmArgs(String defaultJvmArgs) {
        if (StringUtils.stripToNull((String)this.jvmArgs) == null) {
            this.setJvmArgs(defaultJvmArgs);
        }
    }

    @VisibleForTesting
    String getDebugArgs() {
        return this.debugArgs;
    }

    void setDebugArgs(String debugArgs) {
        this.debugArgs = StringUtils.defaultString((String)debugArgs, (String)"");
    }

    public ArtifactRetriever getArtifactRetriever() {
        return this.artifactRetriever;
    }

    public void setArtifactRetriever(ArtifactRetriever artifactRetriever) {
        this.artifactRetriever = artifactRetriever;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDataVersion() {
        return this.productDataVersion;
    }

    public void setDataVersion(String productDataVersion) {
        this.productDataVersion = productDataVersion;
    }

    public String getResolvedVersion() {
        return this.resolvedVersion;
    }

    public void setResolvedVersion(String resolvedVersion) {
        this.resolvedVersion = resolvedVersion;
    }

    @Deprecated
    public String getProductDataVersion() {
        return this.productDataVersion;
    }

    @Deprecated
    public void setProductDataVersion(String productDataVersion) {
        this.productDataVersion = productDataVersion;
    }

    public String getDataPath() {
        return this.productDataPath;
    }

    public void setDataPath(String productDataPath) {
        this.productDataPath = productDataPath;
    }

    public String getDataOverridesPath() {
        return this.dataOverridesPath;
    }

    public void setDataOverridesPath(String productHomeOverridesPath) {
        this.dataOverridesPath = productHomeOverridesPath;
    }

    @Deprecated
    public String getProductDataPath() {
        return this.productDataPath;
    }

    @Deprecated
    public void setProductDataPath(String productDataPath) {
        this.productDataPath = productDataPath;
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(List<Application> applications) {
        this.applications = applications;
    }

    public List<ProductArtifact> getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public void setPluginArtifacts(List<ProductArtifact> pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    public List<ProductArtifact> getLibArtifacts() {
        return this.libArtifacts;
    }

    public void setLibArtifacts(List<ProductArtifact> libArtifacts) {
        this.libArtifacts = libArtifacts;
    }

    public List<ProductArtifact> getBundledArtifacts() {
        return Collections.unmodifiableList(this.bundledArtifacts);
    }

    public void setBundledArtifacts(@Nonnull List<ProductArtifact> bundledArtifacts) {
        this.bundledArtifacts.clear();
        this.bundledArtifacts.addAll(bundledArtifacts);
    }

    public void addBundledArtifacts(Collection<ProductArtifact> newBundledArtifacts) {
        this.bundledArtifacts.addAll(newBundledArtifacts);
    }

    public File getLog4jProperties() {
        return this.log4jProperties;
    }

    public void setLog4jProperties(File log4jProperties) {
        this.log4jProperties = log4jProperties;
    }

    public File getLog4j2Config() {
        return this.log4j2Config;
    }

    public void setLog4j2Config(File log4j2Config) {
        this.log4j2Config = log4j2Config;
    }

    public String getRestVersion() {
        return this.restVersion;
    }

    public void setRestVersion(String restVersion) {
        this.restVersion = restVersion;
    }

    public String getSalVersion() {
        return this.salVersion;
    }

    public void setSalVersion(String salVersion) {
        this.salVersion = salVersion;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public Boolean isInstallPlugin() {
        return this.installPlugin;
    }

    public void setInstallPlugin(Boolean installPlugin) {
        this.installPlugin = installPlugin;
    }

    public String getWebConsoleVersion() {
        return this.webConsoleVersion;
    }

    public Boolean isEnableDevToolbox() {
        return this.enableDevToolbox;
    }

    public Boolean isEnableWebConsole() {
        return this.enableWebConsole;
    }

    public Boolean isEnableAchoo() {
        return this.enableAchoo;
    }

    public void setEnableAchoo(boolean enableAchoo) {
        this.enableAchoo = enableAchoo;
    }

    public String getAchooVersion() {
        return this.achooVersion;
    }

    public void setAchooVersion(String achooVersion) {
        this.achooVersion = achooVersion;
    }

    public void setEnableDevToolbox(Boolean enableDevToolbox) {
        this.enableDevToolbox = enableDevToolbox;
    }

    public void setEnableWebConsole(Boolean enableWebConsole) {
        this.enableWebConsole = enableWebConsole;
    }

    public String getQuickReloadVersion() {
        return this.quickReloadVersion;
    }

    public void setQuickReloadVersion(String quickReloadVersion) {
        this.quickReloadVersion = quickReloadVersion;
    }

    public Boolean isEnableQuickReload() {
        return this.enableQuickReload;
    }

    public void setEnableQuickReload(Boolean enableQuickReload) {
        this.enableQuickReload = enableQuickReload;
    }

    public String getPluginViewerVersion() {
        return this.pluginViewerVersion;
    }

    public void setPluginViewerVersion(String pluginViewerVersion) {
        this.pluginViewerVersion = pluginViewerVersion;
    }

    public Boolean isEnablePluginViewer() {
        return this.enablePluginViewer;
    }

    public void setEnablePluginViewer(Boolean enablePluginViewer) {
        this.enablePluginViewer = enablePluginViewer;
    }

    public String getDevToolboxVersion() {
        return this.devToolboxVersion;
    }

    public void setDevToolboxVersion(String devToolboxVersion) {
        this.devToolboxVersion = devToolboxVersion;
    }

    public Boolean isEnablePde() {
        return this.enablePde;
    }

    public void setEnablePde(Boolean enablePde) {
        this.enablePde = enablePde;
    }

    public String getPdeVersion() {
        return this.pdeVersion;
    }

    public void setPdeVersion(String pdeVersion) {
        this.pdeVersion = pdeVersion;
    }

    public void setWebConsoleVersion(String webConsoleVersion) {
        this.webConsoleVersion = webConsoleVersion;
    }

    @Deprecated
    public void setSystemProperties(Properties systemProperties) {
        systemProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.systemProperties.put(key.toString(), value)));
    }

    @Deprecated
    public Properties getSystemProperties() {
        Properties props = new Properties();
        props.putAll(this.systemProperties);
        return props;
    }

    public void setSystemPropertyVariables(Map<String, Object> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map<String, Object> getSystemPropertyVariables() {
        return this.systemProperties;
    }

    public void defaultSystemProperty(String key, Supplier<String> valueSupplier) {
        this.systemProperties.computeIfAbsent(key, k -> valueSupplier.get());
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    @VisibleForTesting
    int getJvmDebugPort() {
        return this.jvmDebugPort;
    }

    void setJvmDebugPort(int jvmDebugPort) {
        this.jvmDebugPort = jvmDebugPort;
    }

    public int getStartupTimeout() {
        return this.startupTimeout;
    }

    public void setStartupTimeout(int startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setSystemProperties(Map<String, Object> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Boolean getSynchronousStartup() {
        return this.synchronousStartup;
    }

    public void setSynchronousStartup(Boolean synchronousStartup) {
        this.synchronousStartup = synchronousStartup;
    }

    public String getDataHome() {
        return this.dataHome;
    }

    public void setDataHome(String dataHome) {
        this.dataHome = dataHome;
    }

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public String getSharedHome() {
        return this.sharedHome;
    }

    public void setSharedHome(String sharedHome) {
        this.sharedHome = sharedHome;
    }

    @VisibleForTesting
    int getAjpPort() {
        return this.ajpPort;
    }

    void setAjpPort(int ajpPort) {
        this.ajpPort = ajpPort;
    }

    public String toString() {
        return "Product " + this.id + " [instanceId=" + this.instanceId + "]";
    }

    public String getBaseUrlForNode(int nodeIndex) {
        return this.getBaseUrlForPort(this.getNodes().get(nodeIndex).getWebPort());
    }

    public String getBaseUrlForPort(int actualHttpPort) {
        if (actualHttpPort == 0) {
            throw new IllegalArgumentException("Invalid or unresolved web port");
        }
        return BaseUrlUtils.getBaseUrl(this.server, actualHttpPort, this.contextPath);
    }

    public String getProtocol() {
        return this.isHttps() ? "https" : "http";
    }

    public boolean isHttps() {
        return Boolean.TRUE.equals(this.useHttps);
    }

    public boolean isAwaitFullInitialization() {
        if (this.awaitFullInitialization != null) {
            return this.awaitFullInitialization;
        }
        return true;
    }

    public void setAwaitFullInitialization(Boolean awaitFullInitialization) {
        this.awaitFullInitialization = awaitFullInitialization;
    }

    @Nullable
    public Collection<XmlOverride> getCargoXmlOverrides() {
        return this.cargoXmlOverrides;
    }

    public void setCargoXmlOverrides(Collection<XmlOverride> cargoXmlOverrides) {
        this.cargoXmlOverrides = cargoXmlOverrides;
    }

    @Nullable
    public Consumer<Document> getContextXmlModifier() {
        return this.contextXmlModifier;
    }

    public void setContextXmlModifier(Consumer<Document> modifier) {
        this.contextXmlModifier = modifier;
    }

    public boolean isContainerNotSpecified() {
        return this.containerNotSpecified;
    }

    public void setContainerNotSpecified(boolean containerNotSpecified) {
        this.containerNotSpecified = containerNotSpecified;
    }

    @Nullable
    String getLicense() {
        return this.license;
    }

    public boolean is(String productId) {
        return Objects.equals(productId, this.id);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void initialiseNodes() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            this.nodes = Collections.singletonList(new Node(this.isHttps(), this.ajpPort, this.jvmDebugPort, this.httpPort, this.httpsPort, this.rmiPort, this.debugArgs));
        }
        for (Node node : this.nodes) {
            node.ensureNonDebugPortsAreSet(this.instanceId);
        }
    }

    void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void setSynchronicity(boolean parallel) {
        if (parallel) {
            if (this.synchronousStartup == null) {
                this.synchronousStartup = false;
            }
        } else {
            this.synchronousStartup = true;
        }
    }

    public void setNodeDebugArgs(boolean suspend, Log log) {
        if (this.nodes == null || this.nodes.isEmpty()) {
            throw new IllegalStateException(String.format("No nodes set for instance '%s'", this.instanceId));
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node = this.nodes.get(i);
            int debugPort = node.getJvmDebugPort();
            if (debugPort == 0) {
                throw new IllegalStateException(String.format("No debug port set for node %d of instance '%s'", i, this.instanceId));
            }
            node.defaultDebugArgs(suspend);
            log.info((CharSequence)String.format("Debug port for node %d of %s is %d", i, this.instanceId, debugPort));
        }
    }

    public String getSingleNodeDebugArgs() {
        return this.getSingleNodeProperty(Node::getDebugArgs);
    }

    public int getSingleNodeWebPort() {
        return this.getSingleNodeProperty(Node::getWebPort);
    }

    private <R> R getSingleNodeProperty(Function<Node, R> accessor) {
        List<Node> populatedNodes = this.getNodes();
        if (populatedNodes.size() == 1) {
            return accessor.apply(populatedNodes.get(0));
        }
        throw new IllegalStateException("Expected one node but found " + populatedNodes);
    }

    @Nonnull
    public Map<String, String> getSystemPropertiesForNode(int nodeIndex) {
        HashMap<String, String> combinedProperties = new HashMap<String, String>();
        this.systemProperties.forEach((key, value) -> combinedProperties.put((String)key, String.valueOf(value)));
        combinedProperties.putAll(this.getNodes().get(nodeIndex).getSystemProperties());
        return combinedProperties;
    }

    @Nonnull
    public List<Integer> getWebPorts() {
        ArrayList<Integer> webPorts = new ArrayList<Integer>();
        for (Node node : this.getNodes()) {
            int webPort = node.getWebPort();
            if (webPort == 0) {
                throw new IllegalStateException("Web port not set for node " + node);
            }
            webPorts.add(webPort);
        }
        return webPorts;
    }

    public int getWebPortForNode(int nodeIndex) {
        int webPort = this.getNodes().get(nodeIndex).getWebPort();
        if (webPort == 0) {
            throw new IllegalStateException("Web port not set or resolved for node " + nodeIndex);
        }
        return webPort;
    }

    public boolean isMultiNode() {
        return this.getNodes().size() > 1;
    }

    public Optional<URI> getStatusUri(int nodeIndex) {
        if ("confluence".equals(this.id) && this.isMultiNode()) {
            String url = this.getBaseUrlForNode(nodeIndex) + "/status";
            return Optional.of(URI.create(url));
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<String> getUserConfiguredLicense() {
        return Optional.ofNullable(StringUtils.trimToNull((String)StringUtils.remove((String)this.license, (char)' ')));
    }

    public boolean hasUserConfiguredLicense() {
        return StringUtils.isNotBlank((CharSequence)this.license);
    }

    public UpmConfigHandler getUpmConfigHandler() {
        return this.upmConfigHandler;
    }
}

