/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.verification;

import com.atlassian.maven.plugins.amps.frontend.association.FeManifestAssociationConstants;
import com.atlassian.maven.plugins.amps.frontend.association.verification.ArtifactScanner;
import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsChecker;
import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsReader;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.ArtifactScanResults;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.FailurePreferences;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.ModuleScanResults;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.NestedModuleDeclarationData;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.ArtifactPathUtils;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.TrueZipUtils;
import com.atlassian.maven.plugins.amps.osgi.OsgiHelper;
import com.atlassian.maven.plugins.amps.util.ProjectUtils;
import com.google.common.annotations.VisibleForTesting;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="verify-fe-manifest-associations", defaultPhase=LifecyclePhase.VERIFY, requiresProject=false)
public class VerifyFeManifestAssociationsMojo
extends AbstractMojo {
    @Parameter(property="verify.fe.manifest.associations.inputEntrypoint", alias="verifyFeManifestAssociationsInputEntrypoint")
    private String inputEntrypoint;
    @Parameter(property="verify.fe.manifest.associations.failOnUndeclaredFiles", alias="verifyFeManifestAssociationsFailOnUndeclaredFiles", defaultValue="true")
    private Boolean failOnUndeclaredFiles;
    @Parameter(property="verify.fe.manifest.associations.failOnExtraDeclarations", alias="verifyFeManifestAssociationsFailOnExtraDeclarations", defaultValue="true")
    private Boolean failOnExtraDeclarations;
    @Parameter(property="verify.fe.manifest.associations.skip", alias="skipVerifyFeManifestAssociations", defaultValue="false")
    private boolean skipVerifyFeManifestAssociations;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter
    private Map instructions = new HashMap();
    private final Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private static final String DEFAULT_LIFECYCLE_EXECUTION_ID = "default-verify-fe-manifest-associations";
    @Component
    private ArtifactScanner artifactScanner;
    @Component
    private DeclarationsReader declarationsReader;
    @Component
    private DeclarationsChecker declarationsChecker;

    public void execute() throws MojoExecutionException {
        if (this.skipVerifyFeManifestAssociations) {
            this.logger.info("Skipping execute frontend manifest associations verification");
            return;
        }
        if (this.isLifecycleExecution()) {
            if (ProjectUtils.isAtlassianProject(this.project)) {
                this.logger.info("Running the verification of all the javascript files having association with frontend manifest files (package.json and lock file)\nThe execution was started from the default atlassian plugin build lifecycle.\nYou can remove any explicit executions of `verify-fe-manifest-associations` goal from your configuration.");
            } else {
                return;
            }
        }
        this.setInputEntrypoint();
        this.logger.info("Verifying frontend manifest associations for an artifact: {}", (Object)this.inputEntrypoint);
        FailurePreferences failurePreferences = new FailurePreferences(this.failOnUndeclaredFiles, this.failOnExtraDeclarations);
        this.verifyManifestAssociations(this.inputEntrypoint, failurePreferences);
    }

    @VisibleForTesting
    protected void verifyManifestAssociations(String inputEntrypoint, FailurePreferences failurePreferences) throws MojoExecutionException {
        TrueZipUtils.configureTrueZip();
        this.declarationsChecker.setFailurePreferences(failurePreferences);
        try {
            this.scanEntrypoint(inputEntrypoint);
            this.declarationsChecker.finalizeChecks();
        }
        finally {
            TrueZipUtils.unmountTrueZip();
        }
    }

    private void scanEntrypoint(String inputEntrypoint) throws MojoExecutionException {
        ArrayList<MutablePair<TFile, ArtifactScanResults>> completeScanData = this.runRecursiveScan(inputEntrypoint);
        Map<TFile, NestedModuleDeclarationData> nestedModuleDeclarations = this.getNestedModuleDeclarations(completeScanData);
        nestedModuleDeclarations.putAll(VerifyFeManifestAssociationsMojo.getExpandedNestedModuleDeclarations(nestedModuleDeclarations));
        this.verifyAllModules(completeScanData, nestedModuleDeclarations);
    }

    private void verifyAllModules(ArrayList<MutablePair<TFile, ArtifactScanResults>> completeScanData, Map<TFile, NestedModuleDeclarationData> nestedModuleDeclarations) throws MojoExecutionException {
        for (MutablePair<TFile, ArtifactScanResults> artifactScanData : completeScanData) {
            ArtifactScanResults scanResults = (ArtifactScanResults)((Object)artifactScanData.getRight());
            this.verifyModules(scanResults.getModules(), nestedModuleDeclarations);
        }
    }

    private static Map<TFile, NestedModuleDeclarationData> getExpandedNestedModuleDeclarations(Map<TFile, NestedModuleDeclarationData> nestedModuleDeclarations) {
        HashMap<TFile, NestedModuleDeclarationData> expandedModuleDeclarations = new HashMap<TFile, NestedModuleDeclarationData>();
        block0: for (Map.Entry<TFile, NestedModuleDeclarationData> nestedModuleData : nestedModuleDeclarations.entrySet()) {
            TFile parent;
            TFile modulePath = nestedModuleData.getKey();
            NestedModuleDeclarationData moduleData = nestedModuleData.getValue();
            String nestedModuleName = modulePath.getName();
            while ((parent = modulePath.getParentFile()) != null && parent.getPath().endsWith(FeManifestAssociationConstants.METAINF_LIB_DIRECTORY_NAME)) {
                if (!modulePath.getName().equals(nestedModuleName)) {
                    TFile modulePathInParent = new TFile((File)parent, nestedModuleName);
                    if (expandedModuleDeclarations.containsKey(modulePathInParent)) continue block0;
                    expandedModuleDeclarations.put(modulePathInParent, moduleData);
                }
                assert (parent.getParentFile() != null);
                modulePath = parent.getParentFile().getParentFile();
                assert (modulePath != null);
            }
        }
        return expandedModuleDeclarations;
    }

    private Map<TFile, NestedModuleDeclarationData> getNestedModuleDeclarations(ArrayList<MutablePair<TFile, ArtifactScanResults>> completeScanData) throws MojoExecutionException {
        HashMap<TFile, NestedModuleDeclarationData> nestedModuleDeclarations = new HashMap<TFile, NestedModuleDeclarationData>();
        for (MutablePair<TFile, ArtifactScanResults> artifactScanData : completeScanData) {
            ArtifactScanResults scanResults = (ArtifactScanResults)((Object)artifactScanData.getRight());
            nestedModuleDeclarations.putAll(this.processNestedDeclarations(scanResults.getModules()));
        }
        return nestedModuleDeclarations;
    }

    private ArrayList<MutablePair<TFile, ArtifactScanResults>> runRecursiveScan(String inputEntrypoint) throws MojoExecutionException {
        ArrayList<MutablePair<TFile, ArtifactScanResults>> result = new ArrayList<MutablePair<TFile, ArtifactScanResults>>();
        ArrayDeque<TFile> queue = new ArrayDeque<TFile>();
        TFile root = new TFile(inputEntrypoint);
        queue.add(root);
        while (!queue.isEmpty()) {
            TFile currentArtifact = (TFile)queue.poll();
            ArtifactScanResults scanResults = this.artifactScanner.scan(currentArtifact);
            result.add((MutablePair<TFile, ArtifactScanResults>)new MutablePair((Object)currentArtifact, (Object)scanResults));
            queue.addAll(scanResults.getArchiveFiles());
        }
        return result;
    }

    private Map<TFile, NestedModuleDeclarationData> processNestedDeclarations(Map<TFile, ModuleScanResults> modules) throws MojoExecutionException {
        HashMap<TFile, NestedModuleDeclarationData> nestedModuleDeclarations = new HashMap<TFile, NestedModuleDeclarationData>();
        for (Map.Entry<TFile, ModuleScanResults> module : modules.entrySet()) {
            TFile moduleRoot = module.getKey();
            ModuleScanResults moduleScanResults = module.getValue();
            if (!moduleScanResults.hasNestedDeclarationFiles()) continue;
            nestedModuleDeclarations.putAll(this.declarationsReader.readNestedModuleDeclarationData(moduleScanResults.getNestedDeclarationFiles(), moduleRoot));
        }
        return nestedModuleDeclarations;
    }

    private void verifyModules(Map<TFile, ModuleScanResults> modules, Map<TFile, NestedModuleDeclarationData> nestedModuleDeclarations) throws MojoExecutionException {
        for (Map.Entry<TFile, ModuleScanResults> module : modules.entrySet()) {
            TFile moduleRoot = module.getKey();
            ModuleScanResults moduleScanResults = module.getValue();
            Set<String> moduleRelativeJsFiles = ArtifactPathUtils.getRelativePaths(moduleScanResults.getJavascriptFiles(), moduleRoot);
            if (nestedModuleDeclarations.containsKey(moduleRoot)) {
                NestedModuleDeclarationData nestedModuleData = nestedModuleDeclarations.get(moduleRoot);
                this.declarationsChecker.verifyExternalModule(moduleRoot, nestedModuleData, moduleRelativeJsFiles);
                continue;
            }
            Set<String> moduleRelativeDeclarations = this.declarationsReader.readRelativeDeclarations(moduleScanResults.getAssociationFiles(), moduleRoot);
            this.declarationsChecker.verifyModule(moduleRoot, moduleRelativeDeclarations, moduleRelativeJsFiles);
        }
    }

    private void setInputEntrypoint() throws MojoExecutionException {
        String extension;
        String buildFinalName;
        String buildDir;
        if (this.inputEntrypoint != null) {
            return;
        }
        if (this.project != null) {
            buildDir = this.project.getBuild().getDirectory();
            buildFinalName = this.project.getBuild().getFinalName();
            extension = this.getProjectArtifactExtensions(this.project);
            if (!StringUtils.isNotBlank((CharSequence)extension)) {
                throw new MojoExecutionException("Verification entrypoint hasn't been provided and couldn't be derived from project configuration. Please configure `verifyFeManifestAssociationsInputEntrypoint` property or skip artifact verification with `skipVerifyFeManifestAssociations`");
            }
        } else {
            throw new MojoExecutionException("Verification entrypoint is required. Please provide `verifyFeManifestAssociationsInputEntrypoint` propertywith path to input artifact or directory which will be verified");
        }
        this.inputEntrypoint = Paths.get(buildDir, String.format("%s.%s", buildFinalName, extension)).toString();
    }

    private String getProjectArtifactExtensions(MavenProject project) {
        String packaging = project.getPackaging();
        String extension = null;
        switch (packaging) {
            case "atlassian-plugin": {
                if (OsgiHelper.canCreateObrArtifact(this.instructions)) {
                    extension = "obr";
                    break;
                }
                extension = "jar";
                break;
            }
            case "jar": 
            case "war": {
                extension = packaging;
            }
        }
        return extension;
    }

    private boolean isLifecycleExecution() {
        String executionId = this.mojoExecution.getExecutionId();
        return executionId.equals(DEFAULT_LIFECYCLE_EXECUTION_ID);
    }
}

