/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.verification.impl;

import com.atlassian.maven.plugins.amps.frontend.association.FeManifestAssociationConstants;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeOutputJsFileDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.verification.DeclarationsReader;
import com.atlassian.maven.plugins.amps.frontend.association.verification.model.NestedModuleDeclarationData;
import com.atlassian.maven.plugins.amps.frontend.association.verification.utils.ArtifactPathUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;

public class DeclarationsReaderImpl
implements DeclarationsReader {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final MavenXpp3Reader mavenReader = new MavenXpp3Reader();

    @Override
    public Set<String> readRelativeDeclarations(Collection<TFile> associationFiles, TFile moduleRoot) throws MojoExecutionException {
        Set<TFile> declaredFiles = this.readDeclarations(associationFiles).stream().map(relativePath -> new TFile((File)moduleRoot, relativePath)).collect(Collectors.toSet());
        return ArtifactPathUtils.getRelativePaths(declaredFiles, moduleRoot);
    }

    @Override
    public Map<TFile, NestedModuleDeclarationData> readNestedModuleDeclarationData(Collection<TFile> declarationFiles, TFile moduleRoot) throws MojoExecutionException {
        HashMap<TFile, NestedModuleDeclarationData> nestedModuleDeclarations = new HashMap<TFile, NestedModuleDeclarationData>();
        for (TFile declarationFile : declarationFiles) {
            Map<String, List<String>> artifactDeclarations = this.readDeclarationFile(declarationFile);
            this.addNestedModuleDeclarations(nestedModuleDeclarations, moduleRoot, artifactDeclarations);
        }
        return nestedModuleDeclarations;
    }

    private void addNestedModuleDeclarations(Map<TFile, NestedModuleDeclarationData> nestedModuleDeclarations, TFile moduleRoot, Map<String, List<String>> artifactDeclarations) {
        for (Map.Entry<String, List<String>> artifactDeclaration : artifactDeclarations.entrySet()) {
            String relativeArtifactPath = artifactDeclaration.getKey();
            HashSet<String> declaredFiles = new HashSet<String>((Collection)artifactDeclaration.getValue());
            NestedModuleDeclarationData nestedModuleData = new NestedModuleDeclarationData(declaredFiles);
            TFile artifactFile = new TFile((File)moduleRoot, relativeArtifactPath);
            nestedModuleDeclarations.put(artifactFile, nestedModuleData);
        }
    }

    private Set<String> readDeclarations(Collection<TFile> associationFiles) throws MojoExecutionException {
        HashSet<String> declaredFiles = new HashSet<String>();
        for (TFile file : associationFiles) {
            Map<String, FeOutputJsFileDeclaration> associations = this.readAssociationFile(file);
            Set<String> declarations = associations.keySet();
            Set jsDeclarations = declarations.stream().filter(path -> FeManifestAssociationConstants.JAVASCRIPT_FILE_REGEX.matcher((CharSequence)path).matches()).collect(Collectors.toSet());
            declaredFiles.addAll(jsDeclarations);
        }
        return declaredFiles;
    }

    private Map<String, FeOutputJsFileDeclaration> readAssociationFile(TFile file) throws MojoExecutionException {
        try {
            TFileReader reader = new TFileReader(file);
            return (Map)this.objectMapper.readValue((Reader)reader, (TypeReference)new TypeReference<Map<String, FeOutputJsFileDeclaration>>(){});
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading:\n" + file + "\n" + e);
        }
    }

    private Map<String, List<String>> readDeclarationFile(TFile file) throws MojoExecutionException {
        try {
            TFileReader reader = new TFileReader(file);
            return (Map)this.objectMapper.readValue((Reader)reader, (TypeReference)new TypeReference<Map<String, List<String>>>(){});
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading:\n" + file + "\n" + e);
        }
    }
}

