/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.license;

import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.license.LicenseBackdoorClient;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

@ParametersAreNonnullByDefault
public class LicenseInstaller {
    private final Log log;

    public LicenseInstaller(Log log) {
        this.log = Objects.requireNonNull(log);
    }

    public void installLicense(Product product, int webPort) throws MojoExecutionException {
        Optional<String> license = product.getUserConfiguredLicense();
        if (license.isPresent()) {
            LicenseBackdoorClient licenseBackdoorClient = new LicenseBackdoorClient(webPort, product.getProtocol(), product.getServer(), product.getContextPath(), this.log);
            if (!licenseBackdoorClient.installProductLicense(license.get())) {
                throw new MojoExecutionException(String.format("Could not install %s license", product.getId()));
            }
            this.log.info((CharSequence)String.format("Applied provided license to %s", product.getId()));
        }
    }
}

