/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.osgi.AtlassianPluginContentValidator;
import com.atlassian.maven.plugins.amps.osgi.ValidateManifestEntries;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="validate-manifest")
public class ValidateManifestMojo
extends AbstractAmpsMojo {
    @Parameter(property="manifest.validation.skip")
    protected boolean skipManifestValidation = false;
    @Parameter(property="expected.imports.path")
    private String expectedImportsPath;
    @Parameter
    private Map<String, String> instructions = new HashMap<String, String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        File mfile = FileUtils.file(this.getMavenContext().getProject().getBuild().getOutputDirectory(), "META-INF", "MANIFEST.MF");
        if (!this.skipManifestValidation && mfile.exists()) {
            this.getLog().info((CharSequence)"Manifest found, validating...");
            try {
                this.checkManifestEndsWithNewLine(mfile);
                if (this.instructions.containsKey("Atlassian-Plugin-Key")) {
                    AtlassianPluginContentValidator validator = new AtlassianPluginContentValidator();
                    validator.validate(FileUtils.file(this.getMavenContext().getProject().getBuild().getOutputDirectory(), "atlassian-plugin.xml"));
                }
                if (this.expectedImportsPath != null && !this.expectedImportsPath.isEmpty()) {
                    this.getLog().warn((CharSequence)"Validating OSGi imports is experimental and may change in the future without further notice.");
                    this.getLog().info((CharSequence)("Validating OSGi imports against " + this.expectedImportsPath));
                    String actualImports = this.getManifestImports(mfile);
                    String expectedImports = this.getExpectedImports();
                    ValidateManifestEntries.validate(actualImports, expectedImports);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read manifest", (Exception)e);
            }
            this.getLog().info((CharSequence)"Manifest validated");
        } else {
            this.getLog().info((CharSequence)"No manifest found or validation skip flag specified, skipping validation");
        }
    }

    private String getExpectedImports() throws IOException {
        File expectedImports = FileUtils.file(this.expectedImportsPath, new String[0]);
        try (Stream<String> lines = Files.lines(expectedImports.toPath());){
            String string = lines.filter(line -> !line.isEmpty()).map(String::trim).filter(line -> !line.startsWith("#")).collect(Collectors.joining());
            return string;
        }
    }

    private String getManifestImports(File mFile) throws IOException {
        try (InputStream is = Files.newInputStream(mFile.toPath(), new OpenOption[0]);){
            Manifest manifest = new Manifest(is);
            String string = manifest.getMainAttributes().getValue("Import-Package");
            return string;
        }
    }

    private void checkManifestEndsWithNewLine(File mfile) throws IOException, MojoExecutionException, MojoFailureException {
        try (FileInputStream is = new FileInputStream(mfile);){
            long bytesToSkip = mfile.length() - 1L;
            long bytesSkipped = ((InputStream)is).skip(bytesToSkip);
            if (bytesSkipped != bytesToSkip) {
                throw new MojoExecutionException("Could not skip " + bytesToSkip + " bytes reading " + mfile.getAbsolutePath());
            }
            if (((InputStream)is).read() != 10) {
                throw new MojoFailureException("Manifests must end with a new line. " + mfile.getAbsolutePath() + " doesn't.");
            }
        }
    }
}

