/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.pdk;

import com.atlassian.maven.plugins.amps.InstallParams;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class PluginInstaller {
    public static final String PENDING_TASK_JSON = "application/vnd.atl.plugins.pending-task+json";
    private final Log log;
    private final ObjectMapper objectMapper;
    private static final String TITLE = "Install Plugin ";

    public PluginInstaller(Log log) {
        this.log = log;
        this.objectMapper = new ObjectMapper();
    }

    private Header buildAuthHeader(String username, String password) {
        String authString = username + ":" + password;
        String auth = "Basic " + Base64.getEncoder().encodeToString(authString.getBytes(StandardCharsets.US_ASCII));
        return new BasicHeader("Authorization", auth);
    }

    private static String getHeaderValue(String name, HttpResponse response) {
        return Optional.ofNullable(response.getFirstHeader(name)).map(NameValuePair::getValue).orElse(null);
    }

    private static String getLocation(HttpResponse response) {
        return PluginInstaller.getHeaderValue("Location", response);
    }

    private static String getContentType(HttpResponse response) {
        return PluginInstaller.getHeaderValue("Content-Type", response);
    }

    public String getUpmToken(CloseableHttpClient httpClient, InstallParams installParams) throws IOException {
        HttpHead head = new HttpHead(installParams.getUpmUrl());
        head.setHeader("Accept", "*/*");
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)head);
        return PluginInstaller.getHeaderValue("upm-token", (HttpResponse)response);
    }

    public CloseableHttpClient createHttpClient(String username, String password, boolean useHttps) throws MojoExecutionException {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultHeaders(Collections.singletonList(this.buildAuthHeader(username, password))).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(requestConfig).evictIdleConnections(30L, TimeUnit.SECONDS);
        if (useHttps) {
            try {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
            }
            catch (GeneralSecurityException e) {
                throw new MojoExecutionException("Error while configuring SSL", (Exception)e);
            }
        }
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void installPlugin(InstallParams installParams) throws MojoExecutionException {
        File pluginFile = installParams.getPluginFile();
        String title = this.getTitle(installParams.getPluginKey());
        try (CloseableHttpClient httpClient = this.createHttpClient(installParams.getUsername(), installParams.getPassword(), installParams.useHttps());){
            String token = this.getUpmToken(httpClient, installParams);
            if (token == null) {
                throw new MojoExecutionException(title + " : Couldn't get the token from upm.");
            }
            HttpPost uploadPost = new HttpPost(installParams.getUpmUrl() + "?token=" + token);
            uploadPost.setHeader("X-Atlassian-Token", "no-check");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("plugin", (ContentBody)new FileBody(pluginFile, ContentType.APPLICATION_OCTET_STREAM, pluginFile.getName()));
            String signature = installParams.getSignature();
            if (signature != null) {
                builder.addPart("signature", (ContentBody)new StringBody("{\"signature\":\"" + signature + "\"}", ContentType.APPLICATION_JSON));
            } else {
                this.log.info((CharSequence)"No signature provided : Signature check must be disabled on the server.");
            }
            uploadPost.setEntity(builder.build());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)uploadPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                switch (statusCode) {
                    case 200: {
                        this.log.info((CharSequence)(title + " : Completed successfully[" + statusCode + "]."));
                        return;
                    }
                    case 202: {
                        String location = PluginInstaller.getLocation((HttpResponse)response);
                        this.waitForCompletion(httpClient, location, installParams);
                        return;
                    }
                    default: {
                        throw new MojoExecutionException(title + " : Upload failed --- " + statusCode + ": " + responseBody);
                    }
                }
            }
        }
        catch (AsynchronousTaskException | IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private void waitForCompletion(CloseableHttpClient httpClient, String taskLocation, InstallParams installParams) throws AsynchronousTaskException {
        if (taskLocation == null) {
            throw new AsynchronousTaskException("No location provided!");
        }
        for (int i = 0; i < 30; ++i) {
            HttpGet get = new HttpGet(taskLocation);
            get.setHeader("Accept", PENDING_TASK_JSON);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
                int status = response.getStatusLine().getStatusCode();
                String contentType = PluginInstaller.getContentType((HttpResponse)response);
                String body = EntityUtils.toString((HttpEntity)response.getEntity());
                if (PluginInstaller.isAdditionalTaskRequested(status, contentType)) {
                    JsonNode entity = this.readJson(body);
                    this.executeNextTask(httpClient, entity, installParams);
                    break;
                }
                if (status != 200) break;
                if (PluginInstaller.isTaskErrorRepresentation(contentType)) {
                    throw new AsynchronousTaskException("Task error: " + body);
                }
                if (PluginInstaller.isTaskDone(contentType)) {
                    break;
                }
            }
            catch (IOException ioe) {
                throw new AsynchronousTaskException("Error while waiting for installation completion : ", ioe);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.info((CharSequence)"Interrupted!");
            }
        }
    }

    private JsonNode readJson(String payload) throws JsonProcessingException {
        return this.objectMapper.readTree(payload);
    }

    private static boolean isAdditionalTaskRequested(int status, String contentType) {
        return status == 202 && contentType != null && contentType.endsWith("next-task+json");
    }

    private static boolean isTaskErrorRepresentation(String contentType) {
        return contentType != null && contentType.endsWith("err+json");
    }

    private static boolean isTaskDone(String contentType) {
        return contentType != null && contentType.endsWith("complete+json");
    }

    private void executeNextTask(CloseableHttpClient httpClient, JsonNode object, InstallParams installParams) throws AsynchronousTaskException {
        block12: {
            try {
                JsonNode status = object.get("status");
                if (status.has("nextTaskPostUri")) {
                    String uri = status.get("nextTaskPostUri").asText();
                    HttpPost post = new HttpPost(uri);
                    try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                        Header location = response.getFirstHeader("Location");
                        if (location != null) {
                            this.waitForCompletion(httpClient, location.getValue(), installParams);
                        }
                        break block12;
                    }
                }
                if (status.has("cleanupDeleteUri")) {
                    String uri = status.get("cleanupDeleteUri").asText();
                    HttpDelete delete = new HttpDelete(uri);
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)delete);
                    if (response != null) {
                        response.close();
                    }
                    break block12;
                }
                throw new AsynchronousTaskException("status should contain nextTaskPostUri or cleanupDeleteUri, but was: " + status);
            }
            catch (IOException e) {
                throw new AsynchronousTaskException("Error executing next task", e);
            }
        }
    }

    protected String getTitle(String pluginKey) {
        return TITLE + pluginKey;
    }

    private static class AsynchronousTaskException
    extends Exception {
        public AsynchronousTaskException(String s, Throwable cause) {
            super(s, cause);
        }

        public AsynchronousTaskException(String s) {
            super(s);
        }
    }
}

