/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;

final class ConfluenceBundledLibrariesManifestReader {
    static final String BUNDLED_LIBS_METADATA_FILE_PATH = "META-INF/maven/bundled-libs.txt";

    ConfluenceBundledLibrariesManifestReader() {
    }

    public Optional<Set<ProductArtifact>> readBundledLibrariesManifest(File warFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(warFile);){
            Optional<Set<ProductArtifact>> optional;
            ZipEntry entry = zipFile.getEntry(BUNDLED_LIBS_METADATA_FILE_PATH);
            if (entry == null) {
                Optional<Set<ProductArtifact>> optional2 = Optional.empty();
                return optional2;
            }
            try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(entry), StandardCharsets.UTF_8);){
                TreeSet gavs = Sets.newTreeSet((Iterable)CharStreams.readLines((Readable)reader));
                Set artifacts = gavs.stream().map(gav -> {
                    String[] parts = StringUtils.split((String)gav, (char)':');
                    return new ProductArtifact(parts[0], parts[1], parts[2]);
                }).collect(Collectors.toSet());
                optional = Optional.of(artifacts);
            }
            return optional;
        }
    }
}

