/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.product.JavaModulePackage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class JvmArgsFix {
    private final Map<String, String> defaultParams;
    private final Set<JavaModulePackage> addOpens = new LinkedHashSet<JavaModulePackage>();
    private final Set<JavaModulePackage> addExports = new LinkedHashSet<JavaModulePackage>();
    private final Set<File> argsFiles = new LinkedHashSet<File>();

    private JvmArgsFix(Map<String, String> initial) {
        this.defaultParams = new LinkedHashMap<String, String>(initial);
    }

    private JvmArgsFix() {
        this.defaultParams = new LinkedHashMap<String, String>();
    }

    public static JvmArgsFix defaults() {
        return new JvmArgsFix(Collections.singletonMap("-Xmx", "512m"));
    }

    public static JvmArgsFix empty() {
        return new JvmArgsFix();
    }

    public JvmArgsFix with(String param, String value) {
        this.defaultParams.put(param, value);
        return this;
    }

    public JvmArgsFix withAddOpens(JavaModulePackage ... packages) {
        Collections.addAll(this.addOpens, packages);
        return this;
    }

    public JvmArgsFix withAddOpens(Collection<JavaModulePackage> packages) {
        this.addOpens.addAll(packages);
        return this;
    }

    public JvmArgsFix withAddExports(JavaModulePackage ... packages) {
        Collections.addAll(this.addExports, packages);
        return this;
    }

    public JvmArgsFix withAddExports(Collection<JavaModulePackage> packages) {
        this.addExports.addAll(packages);
        return this;
    }

    public JvmArgsFix withArgsFile(File argsFile) {
        this.argsFiles.add(argsFile);
        return this;
    }

    public String apply(String jvmArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)jvmArgs)) {
            args.add(jvmArgs);
        }
        for (Map.Entry<String, String> param : this.defaultParams.entrySet()) {
            if (StringUtils.contains((CharSequence)jvmArgs, (CharSequence)param.getKey())) continue;
            args.add(param.getKey() + param.getValue());
        }
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
            for (JavaModulePackage addOpen : this.addOpens) {
                args.add(addOpen.createAddOpensToUnnamed());
            }
            for (JavaModulePackage addOpen : this.addExports) {
                args.add(addOpen.createAddExportsToUnnamed());
            }
        }
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11)) {
            this.argsFiles.stream().filter(File::isFile).forEach(argFile -> args.add(JvmArgsFix.getCommandLineArg(argFile.getPath())));
        }
        return StringUtils.join(args, (char)' ');
    }

    static String getCommandLineArg(@Nonnull String path) {
        StringBuilder arg = new StringBuilder("@");
        if (path.contains(" ") || path.contains("\"")) {
            arg.append("\"").append(path.replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
        } else {
            arg.append(path);
        }
        return arg.toString();
    }
}

