/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.xml;

import com.atlassian.maven.plugins.amps.xml.SpringXmlServiceProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class SpringXmlComponent {
    private final String id;
    private final String fullClassName;
    private final Map<String, String> serviceProperties;

    private SpringXmlComponent(String id, String fullClassName, Map<String, String> serviceProperties) {
        this.id = id;
        this.fullClassName = fullClassName;
        this.serviceProperties = serviceProperties;
    }

    @JacksonXmlProperty
    String id() {
        return this.id;
    }

    @JacksonXmlProperty
    String fullClassName() {
        return this.fullClassName;
    }

    @JacksonXmlProperty(localName="serviceProperty")
    @JacksonXmlElementWrapper(localName="serviceProperties")
    List<SpringXmlServiceProperty> serviceProperties() {
        return this.serviceProperties.entrySet().stream().map(entry -> SpringXmlServiceProperty.builder().key((String)entry.getKey()).value((String)entry.getValue()).build()).collect(Collectors.toList());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SpringXmlComponent component = (SpringXmlComponent)other;
        if (!Objects.equals(component.id, this.id)) {
            return false;
        }
        if (!Objects.equals(component.fullClassName, this.fullClassName)) {
            return false;
        }
        return Objects.equals(component.serviceProperties, this.serviceProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.fullClassName, this.serviceProperties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id = "";
        private String fullClassName = "";
        private Map<String, String> serviceProperties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public Builder id(String id) {
            if (id == null) {
                throw new IllegalArgumentException("'id' must not be null");
            }
            if (StringUtils.isWhitespace((CharSequence)id)) {
                throw new IllegalArgumentException("'id' must not be blank or whitespace");
            }
            this.id = id;
            return this;
        }

        public Builder fullClassName(String fullClassName) {
            if (fullClassName == null) {
                throw new IllegalArgumentException("'fullClassName' must not be null");
            }
            if (StringUtils.isWhitespace((CharSequence)fullClassName)) {
                throw new IllegalArgumentException("'fullClassName' must not be blank or whitespace");
            }
            this.fullClassName = fullClassName;
            return this;
        }

        public Builder putServiceProperty(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("'key' must not be null");
            }
            if (StringUtils.isWhitespace((CharSequence)key)) {
                throw new IllegalArgumentException("'key' must not be blank or whitespace");
            }
            if (value == null) {
                throw new IllegalArgumentException("'value' must not be null");
            }
            this.serviceProperties.put(key, value);
            return this;
        }

        public SpringXmlComponent build() {
            if (StringUtils.isBlank((CharSequence)this.id)) {
                throw new IllegalStateException("'id' property is mandatory");
            }
            if (StringUtils.isBlank((CharSequence)this.fullClassName)) {
                throw new IllegalStateException("'fullClassName' property is mandatory");
            }
            return new SpringXmlComponent(this.id, this.fullClassName, Collections.unmodifiableMap(this.serviceProperties));
        }
    }
}

