/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.osgi.PluginDependency;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

@Mojo(name="generate-obr-artifact", threadSafe=true)
public class GenerateObrArtifactMojo
extends AbstractAmpsMojo {
    @Parameter
    private List<PluginDependency> pluginDependencies = new ArrayList<PluginDependency>();
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="attach", defaultValue="true")
    private boolean attach;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="project.build.directory")
    protected File outputDirectory;
    @Parameter(property="project.build.finalName")
    protected String finalName;
    @Parameter(property="reactorProjects", readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter
    private Map instructions = new HashMap();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.instructions.isEmpty()) {
                Build build = this.getMavenContext().getProject().getBuild();
                List<File> deps = this.resolvePluginDependencies();
                File obrDir = this.layoutObr(deps, new File(build.getDirectory(), build.getFinalName() + ".jar"));
                this.generateObrZip(obrDir);
            } else {
                this.getLog().info((CharSequence)"Skipping OBR generation... no OSGi bundle manifest instructions found in pom.xml");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void generateObrZip(File obrDir) throws MojoExecutionException {
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        File outputFile = new File(this.outputDirectory, this.finalName + ".obr");
        MavenProject mavenProject = this.getMavenContext().getProject();
        try {
            archiver.getArchiver().addDirectory(obrDir, "");
            archiver.setOutputFile(outputFile);
            this.archive.setAddMavenDescriptor(false);
            this.archive.setForced(true);
            archiver.createArchive(mavenProject, this.archive);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating obr archive: " + e.getMessage(), (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error creating obr archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error creating obr archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error creating obr archive: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.attach) {
            this.projectHelper.attachArtifact(mavenProject, this.getType(), outputFile);
        } else {
            this.getLog().info((CharSequence)("NOT adding " + this.getType() + " to attached artifacts list, so it won't be installed or deployed."));
        }
    }

    private File layoutObr(List<File> deps, File mainArtifact) throws MojoExecutionException, IOException {
        File obrDir = new File(this.getMavenContext().getProject().getBuild().getDirectory(), "obr");
        obrDir.mkdir();
        File depDir = new File(obrDir, "dependencies");
        depDir.mkdir();
        for (File file : deps) {
            FileUtils.copyFileToDirectory((File)file, (File)depDir, (boolean)true);
        }
        File obrXml = new File(obrDir, "obr.xml");
        for (File dep : depDir.listFiles()) {
            this.getMavenGoals().generateObrXml(dep, obrXml);
        }
        File file = new File(obrDir, mainArtifact.getName());
        FileUtils.copyFile((File)mainArtifact, (File)file);
        this.getMavenGoals().generateObrXml(file, obrXml);
        return obrDir;
    }

    private List<File> resolvePluginDependencies() {
        ArrayList<File> deps = new ArrayList<File>();
        for (Artifact artifact : this.getMavenContext().getProject().getDependencyArtifacts()) {
            if (!this.pluginDependencies.contains(new PluginDependency(artifact.getGroupId(), artifact.getArtifactId()))) continue;
            deps.add(artifact.getFile());
        }
        return deps;
    }

    protected String getType() {
        return "obr";
    }
}

