/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.fugue.Option;
import com.atlassian.maven.plugins.amps.Application;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.GroupArtifactPair;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ApplicationMapper {
    private Map<String, Map<String, GroupArtifactPair>> applicationKeys;

    ApplicationMapper(Map<String, Map<String, GroupArtifactPair>> applicationKeys) {
        this.applicationKeys = applicationKeys;
    }

    List<ProductArtifact> provideApplications(final Product product) {
        return (List)Option.option(this.applicationKeys.get(product.getId())).map((Function)new Function<Map<String, GroupArtifactPair>, List<ProductArtifact>>(){

            public List<ProductArtifact> apply(final Map<String, GroupArtifactPair> applicationKeysForProduct) {
                Predicate<Application> isApplicationSupportedByProduct = new Predicate<Application>(){

                    public boolean apply(Application application) {
                        String applicationKey = application.getApplicationKey();
                        return applicationKeysForProduct.containsKey(applicationKey);
                    }
                };
                Function<Application, ProductArtifact> toProductArtifact = new Function<Application, ProductArtifact>(){

                    public ProductArtifact apply(Application application) {
                        String applicationKey = application.getApplicationKey();
                        GroupArtifactPair groupArtifactPair = (GroupArtifactPair)applicationKeysForProduct.get(applicationKey);
                        return groupArtifactPair.createProductArtifactWithVersion(application.getVersion());
                    }
                };
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(product.getApplications(), (Predicate)isApplicationSupportedByProduct), (Function)toProductArtifact));
            }
        }).getOrElse(Collections.emptyList());
    }
}

