/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.concurrent.GuardedBy;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;
import org.ofbiz.core.util.Debug;

public class TransactionFactory {
    @GuardedBy(value="TransactionFactory.class")
    private static volatile TransactionFactoryInterface transactionFactory = null;

    public static TransactionFactoryInterface getTransactionFactory() {
        TransactionFactoryInterface existing = transactionFactory;
        return existing != null ? existing : TransactionFactory.getTransactionFactoryUnderLock();
    }

    private static synchronized TransactionFactoryInterface getTransactionFactoryUnderLock() {
        TransactionFactoryInterface existing = transactionFactory;
        if (existing != null) {
            return existing;
        }
        try {
            TransactionFactoryInterface created;
            transactionFactory = created = TransactionFactory.createTransactionFactory();
            return created;
        }
        catch (SecurityException se) {
            Debug.logError((Throwable)se);
            throw new IllegalStateException("Error loading TransactionFactory class: " + se.getMessage());
        }
    }

    @GuardedBy(value="TransactionFactory.class")
    private static TransactionFactoryInterface createTransactionFactory() {
        String className = EntityConfigUtil.getInstance().getTxFactoryClass();
        if (className == null || className.isEmpty()) {
            throw new IllegalStateException("Could not find transaction factory class name definition");
        }
        Class<?> tfClass = TransactionFactory.loadClass(className);
        try {
            return (TransactionFactoryInterface)tfClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Debug.logWarning((Throwable)e);
            throw new IllegalStateException("Error loading TransactionFactory class \"" + className + "\": " + e.getMessage());
        }
    }

    private static Class<?> loadClass(String className) {
        Class<?> tfClass;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = TransactionFactory.class.getClassLoader();
            }
            tfClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Debug.logWarning((Throwable)e);
            throw new IllegalStateException("Error loading TransactionFactory class \"" + className + "\": " + e.getMessage());
        }
        return tfClass;
    }

    public static TransactionManager getTransactionManager() {
        return TransactionFactory.getTransactionFactory().getTransactionManager();
    }

    public static UserTransaction getUserTransaction() {
        return TransactionFactory.getTransactionFactory().getUserTransaction();
    }

    public static String getTxMgrName() {
        return TransactionFactory.getTransactionFactory().getTxMgrName();
    }

    public static Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        return TransactionFactory.getTransactionFactory().getConnection(helperName);
    }
}

