/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test.rest;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public class ThrowableTypeAdapter
extends TypeAdapter<Throwable> {
    public Throwable read(JsonReader reader) throws IOException {
        String detailMessage = "";
        StackTraceElement[] stackTrace = new StackTraceElement[]{};
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("detailMessage")) {
                detailMessage = reader.nextString();
                continue;
            }
            if (name.equals("stackTrace")) {
                stackTrace = this.readStackTraceElements(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        Throwable throwable = new Throwable(detailMessage);
        throwable.setStackTrace(stackTrace);
        return throwable;
    }

    private StackTraceElement[] readStackTraceElements(JsonReader reader) throws IOException {
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
        reader.beginArray();
        while (reader.hasNext()) {
            stackTraceElements.add(this.readStackTraceElement(reader));
        }
        reader.endArray();
        return stackTraceElements.toArray(new StackTraceElement[0]);
    }

    private StackTraceElement readStackTraceElement(JsonReader reader) throws IOException {
        String declaringClass = "";
        String methodName = "";
        String fileName = "";
        int lineNumber = -1;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("declaringClass")) {
                declaringClass = reader.nextString();
                continue;
            }
            if (name.equals("methodName")) {
                methodName = reader.nextString();
                continue;
            }
            if (name.equals("fileName")) {
                fileName = reader.nextString();
                continue;
            }
            if (name.equals("lineNumber")) {
                lineNumber = reader.nextInt();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
    }

    public void write(JsonWriter out, Throwable value) throws IOException {
        Throwable[] suppressedArray;
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("type");
        out.value(value.getClass().getSimpleName());
        out.name("message");
        out.value(value.getMessage());
        Throwable cause = value.getCause();
        if (cause != null) {
            out.name("cause");
            this.write(out, cause);
        }
        if ((suppressedArray = value.getSuppressed()).length > 0) {
            out.name("suppressed");
            out.beginArray();
            for (Throwable suppressed : suppressedArray) {
                this.write(out, suppressed);
            }
            out.endArray();
        }
        out.endObject();
    }
}

