/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.plugins.rest.common.security.jersey.XsrfResourceFilter;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class XsrfResourceFilterFactory
implements ResourceFilterFactory {
    private HttpContext httpContext;
    private XsrfTokenValidator xsrfTokenValidator;
    private static final String XSRF_ANNOTATION_CLASS_NAME = RequiresXsrfCheck.class.getSimpleName();

    public XsrfResourceFilterFactory(HttpContext httpContext, XsrfTokenValidator xsrfTokenValidator) {
        this.httpContext = (HttpContext)Preconditions.checkNotNull((Object)httpContext);
        this.xsrfTokenValidator = (XsrfTokenValidator)Preconditions.checkNotNull((Object)xsrfTokenValidator);
    }

    public boolean hasXsrfAnnotation(AnnotatedElement annotatedElement) {
        if (annotatedElement.isAnnotationPresent(RequiresXsrfCheck.class)) {
            return true;
        }
        for (Annotation annotation : annotatedElement.getAnnotations()) {
            if (!annotation.annotationType().getSimpleName().equals(XSRF_ANNOTATION_CLASS_NAME)) continue;
            return true;
        }
        return false;
    }

    public List<ResourceFilter> create(AbstractMethod method) {
        if (this.hasXsrfAnnotation((AnnotatedElement)method) || this.hasXsrfAnnotation((AnnotatedElement)method.getResource())) {
            XsrfResourceFilter xsrfResourceFilter = new XsrfResourceFilter();
            xsrfResourceFilter.setHttpContext(this.httpContext);
            xsrfResourceFilter.setXsrfTokenValidator(this.xsrfTokenValidator);
            return Collections.singletonList(xsrfResourceFilter);
        }
        return Collections.emptyList();
    }
}

