/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium.visualcomparison.utils;

import com.atlassian.annotations.Internal;
import com.atlassian.selenium.visualcomparison.utils.BoundingBox;
import com.atlassian.selenium.visualcomparison.utils.Screenshot;
import com.atlassian.selenium.visualcomparison.utils.ScreenshotDiff;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Internal
public class ScreenshotDiffer {
    public ScreenshotDiff diff(Screenshot oldScreen, Screenshot newScreen, List<BoundingBox> ignoreAreas, boolean ignoreSingleLines) throws IOException {
        BufferedImage thisImage = oldScreen.getImage();
        BufferedImage otherImage = newScreen.getImage();
        int thisWidth = thisImage.getWidth();
        int thisHeight = thisImage.getHeight();
        int otherWidth = otherImage.getWidth();
        int otherHeight = otherImage.getHeight();
        int maxWidth = Math.max(thisWidth, otherWidth);
        int maxHeight = Math.max(thisHeight, otherHeight);
        BufferedImage diffImage = new BufferedImage(maxWidth, maxHeight, 1);
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (int x = 0; x < maxWidth; ++x) {
            for (int y = 0; y < maxHeight; ++y) {
                if (x < thisWidth && x < otherWidth && y < thisHeight && y < otherHeight) {
                    int thisPixel = thisImage.getRGB(x, y);
                    int otherPixel = otherImage.getRGB(x, y);
                    if (this.shouldIgnorePixel(x, y, ignoreAreas) || thisPixel == otherPixel) {
                        diffImage.setRGB(x, y, thisPixel);
                        continue;
                    }
                    diffImage.setRGB(x, y, 0xFF0000);
                    boolean foundBox = false;
                    for (BoundingBox box : boxes) {
                        if (!box.isNear(x, y)) continue;
                        box.merge(x, y);
                        foundBox = true;
                    }
                    if (foundBox) continue;
                    boxes.add(new BoundingBox(x, y));
                    continue;
                }
                diffImage.setRGB(x, y, 0);
            }
        }
        if (ignoreSingleLines) {
            BoundingBox.deleteSingleLineBoxes(boxes);
        }
        BoundingBox.mergeOverlappingBoxes(boxes);
        thisImage.flush();
        otherImage.flush();
        return new ScreenshotDiff(oldScreen, newScreen, oldScreen.getId(), oldScreen.getResolution(), diffImage, boxes, ignoreAreas);
    }

    private boolean shouldIgnorePixel(int x, int y, List<BoundingBox> ignoreAreas) {
        if (ignoreAreas == null) {
            return false;
        }
        for (BoundingBox ignoreArea : ignoreAreas) {
            if (!ignoreArea.contains(x, y)) continue;
            return true;
        }
        return false;
    }
}

