/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.tool;

import com.atlassian.upm.signing.tool.PrivateKeyAndCert;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.function.BiConsumer;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignatureBuilder.class);
    private final Ed25519Signer signer;
    private final PrivateKeyAndCert privateKeyAndCert;

    public static SignatureBuilder withPrivateKey(String privateKey) {
        return new SignatureBuilder(new PrivateKeyAndCert(privateKey, null));
    }

    public SignatureBuilder(PrivateKeyAndCert privateKeyAndCert) {
        this.privateKeyAndCert = privateKeyAndCert;
        this.signer = privateKeyAndCert == null ? null : (Ed25519Signer)privateKeyAndCert.buildSigner().orElse(null);
    }

    private <T> String forgeSignature(T data, BiConsumer<T, Ed25519Signer> writer) {
        if (this.signer == null) {
            LOGGER.warn("Null signer");
            return null;
        }
        try {
            this.signer.reset();
            writer.accept(data, this.signer);
            byte[] signatureBytes = this.signer.generateSignature();
            return Base64.getEncoder().encodeToString(signatureBytes);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to sign plugin", (Throwable)e);
            return null;
        }
    }

    public String forgeSignature(File file) {
        String string;
        block8: {
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                string = this.forgeSignature(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return string;
    }

    public String forgeSignature(byte[] dataBytes) {
        return this.forgeSignature(dataBytes, (data, s) -> s.update(data, 0, ((byte[])data).length));
    }

    public String forgeSignature(InputStream inputStream) {
        return this.forgeSignature(inputStream, (in, s) -> {
            try {
                byte[] data = new byte[1024];
                int len = in.read(data);
                while (len != -1) {
                    s.update(data, 0, len);
                    len = in.read(data);
                }
            }
            catch (IOException io) {
                throw new UncheckedIOException(io);
            }
        });
    }

    public static Builder builder(String issuer) {
        return new Builder(issuer);
    }

    public PrivateKeyAndCert getPrivateKeyAndCert() {
        return this.privateKeyAndCert;
    }

    public static class Builder {
        private ZonedDateTime from;
        private ZonedDateTime to;
        private final String issuer;

        private Builder(String issuer) {
            this.issuer = issuer;
        }

        public Builder from(ZonedDateTime from) {
            this.from = from;
            return this;
        }

        public Builder to(ZonedDateTime to) {
            this.to = to;
            return this;
        }

        public SignatureBuilder build() {
            ZonedDateTime start = this.from == null ? ZonedDateTime.now() : this.from;
            ZonedDateTime end = this.to == null ? start.plusDays(1L) : this.to;
            PrivateKeyAndCert privateKeyAndCert = PrivateKeyAndCert.generateSelfSignedX509Certificate(start, end, this.issuer);
            return new SignatureBuilder(privateKeyAndCert);
        }
    }
}

