/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.observer.AttributesObserver;
import com.aventstack.extentreports.observer.ExtentObserver;
import com.aventstack.extentreports.observer.LogObserver;
import com.aventstack.extentreports.observer.MediaObserver;
import com.aventstack.extentreports.observer.ReportObserver;
import com.aventstack.extentreports.observer.TestObserver;
import com.aventstack.extentreports.observer.entity.AttributeEntity;
import com.aventstack.extentreports.observer.entity.LogEntity;
import com.aventstack.extentreports.observer.entity.MediaEntity;
import com.aventstack.extentreports.observer.entity.ReportEntity;
import com.aventstack.extentreports.observer.entity.TestEntity;
import io.reactivex.rxjava3.subjects.PublishSubject;
import lombok.Generated;

abstract class ReactiveSubject {
    private final Report report = Report.builder().build();
    private final PublishSubject<ReportEntity> reportSubject = PublishSubject.create();
    private final PublishSubject<TestEntity> testSubject = PublishSubject.create();
    private final PublishSubject<LogEntity> logSubject = PublishSubject.create();
    private final PublishSubject<MediaEntity> mediaSubject = PublishSubject.create();
    private final PublishSubject<AttributeEntity> attribSubject = PublishSubject.create();

    ReactiveSubject() {
    }

    protected void attachReporter(ExtentObserver ... observers) {
        for (ExtentObserver o : observers) {
            if (o instanceof ReportObserver) {
                this.reportSubject.subscribe(((ReportObserver)o).getReportObserver());
            }
            if (o instanceof TestObserver) {
                this.testSubject.subscribe(((TestObserver)o).getTestObserver());
            }
            if (o instanceof LogObserver) {
                this.logSubject.subscribe(((LogObserver)o).getLogObserver());
            }
            if (o instanceof MediaObserver) {
                this.mediaSubject.subscribe(((MediaObserver)o).getMediaObserver());
            }
            if (!(o instanceof AttributesObserver)) continue;
            this.attribSubject.subscribe(((AttributesObserver)o).getAttributesObserver());
        }
    }

    protected void onTestCreated(Test test) {
        this.testSubject.onNext((Object)TestEntity.builder().test(test).build());
    }

    protected void onTestRemoved(Test test) {
        this.testSubject.onNext((Object)TestEntity.builder().test(test).removed(true).build());
    }

    protected void onLogCreated(Log log, Test test) {
        this.logSubject.onNext((Object)LogEntity.builder().log(log).test(test).build());
    }

    protected void onAuthorAssigned(Author x, Test test) {
        this.attribSubject.onNext((Object)AttributeEntity.builder().author(x).test(test).build());
    }

    protected void onCategoryAssigned(Category x, Test test) {
        this.attribSubject.onNext((Object)AttributeEntity.builder().category(x).test(test).build());
    }

    protected void onDeviceAssigned(Device x, Test test) {
        this.attribSubject.onNext((Object)AttributeEntity.builder().device(x).test(test).build());
    }

    protected void onMediaAdded(Media m, Test test) {
        this.mediaSubject.onNext((Object)MediaEntity.builder().media(m).test(test).build());
    }

    protected void onMediaAdded(Media m, Log log, Test test) {
        this.mediaSubject.onNext((Object)MediaEntity.builder().media(m).test(test).log(log).build());
    }

    protected void onFlush() {
        this.reportSubject.onNext((Object)ReportEntity.builder().report(this.report).build());
    }

    @Generated
    public Report getReport() {
        return this.report;
    }

    @Generated
    public PublishSubject<ReportEntity> getReportSubject() {
        return this.reportSubject;
    }

    @Generated
    public PublishSubject<TestEntity> getTestSubject() {
        return this.testSubject;
    }

    @Generated
    public PublishSubject<LogEntity> getLogSubject() {
        return this.logSubject;
    }

    @Generated
    public PublishSubject<MediaEntity> getMediaSubject() {
        return this.mediaSubject;
    }

    @Generated
    public PublishSubject<AttributeEntity> getAttribSubject() {
        return this.attribSubject;
    }
}

