/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.implementation.AbstractSummaryResultPropertiesHelper;
import com.azure.ai.textanalytics.models.AbstractiveSummary;
import com.azure.ai.textanalytics.models.DetectedLanguage;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsResult;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentStatistics;
import com.azure.core.util.IterableStream;

public final class AbstractSummaryResult
extends TextAnalyticsResult {
    private DetectedLanguage detectedLanguage;
    private IterableStream<AbstractiveSummary> summaries;
    private IterableStream<TextAnalyticsWarning> warnings;

    public AbstractSummaryResult(String id, TextDocumentStatistics textDocumentStatistics, TextAnalyticsError error) {
        super(id, textDocumentStatistics, error);
    }

    public DetectedLanguage getDetectedLanguage() {
        return this.detectedLanguage;
    }

    public IterableStream<AbstractiveSummary> getSummaries() {
        this.throwExceptionIfError();
        return this.summaries;
    }

    public IterableStream<TextAnalyticsWarning> getWarnings() {
        return this.warnings;
    }

    private void setDetectedLanguage(DetectedLanguage detectedLanguage) {
        this.detectedLanguage = detectedLanguage;
    }

    private void setWarnings(IterableStream<TextAnalyticsWarning> warnings) {
        this.warnings = warnings;
    }

    private void setSummaries(IterableStream<AbstractiveSummary> summaries) {
        this.summaries = summaries;
    }

    static {
        AbstractSummaryResultPropertiesHelper.setAccessor(new AbstractSummaryResultPropertiesHelper.AbstractSummaryResultAccessor(){

            @Override
            public void setDetectedLanguage(AbstractSummaryResult documentResult, DetectedLanguage detectedLanguage) {
                documentResult.setDetectedLanguage(detectedLanguage);
            }

            @Override
            public void setWarnings(AbstractSummaryResult documentResult, IterableStream<TextAnalyticsWarning> warnings) {
                documentResult.setWarnings((IterableStream<TextAnalyticsWarning>)warnings);
            }

            @Override
            public void setSummaries(AbstractSummaryResult documentResult, IterableStream<AbstractiveSummary> summaries) {
                documentResult.setSummaries((IterableStream<AbstractiveSummary>)summaries);
            }
        });
    }
}

