/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.implementation.CategorizedEntityPropertiesHelper;
import com.azure.ai.textanalytics.models.BaseResolution;
import com.azure.ai.textanalytics.models.EntityCategory;
import com.azure.core.util.IterableStream;

public final class CategorizedEntity {
    private final String text;
    private final EntityCategory category;
    private final String subcategory;
    private final double confidenceScore;
    private int offset;
    private int length;
    private IterableStream<BaseResolution> resolutions;

    public CategorizedEntity(String text, EntityCategory category, String subcategory, double confidenceScore) {
        this.text = text;
        this.category = category;
        this.subcategory = subcategory;
        this.confidenceScore = confidenceScore;
    }

    public String getText() {
        return this.text;
    }

    public EntityCategory getCategory() {
        return this.category;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public double getConfidenceScore() {
        return this.confidenceScore;
    }

    public int getOffset() {
        return this.offset;
    }

    private void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLength() {
        return this.length;
    }

    private void setLength(int length) {
        this.length = length;
    }

    public IterableStream<? extends BaseResolution> getResolutions() {
        return this.resolutions;
    }

    private void setResolutions(IterableStream<BaseResolution> resolutions) {
        this.resolutions = resolutions;
    }

    static {
        CategorizedEntityPropertiesHelper.setAccessor(new CategorizedEntityPropertiesHelper.CategorizedEntityAccessor(){

            @Override
            public void setLength(CategorizedEntity entity, int length) {
                entity.setLength(length);
            }

            @Override
            public void setOffset(CategorizedEntity entity, int offset) {
                entity.setOffset(offset);
            }

            @Override
            public void setResolutions(CategorizedEntity entity, IterableStream<BaseResolution> resolutions) {
                entity.setResolutions((IterableStream<BaseResolution>)resolutions);
            }
        });
    }
}

