/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.implementation.ExtractSummaryResultPropertiesHelper;
import com.azure.ai.textanalytics.models.DetectedLanguage;
import com.azure.ai.textanalytics.models.SummarySentence;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsResult;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentStatistics;
import com.azure.core.util.IterableStream;

public final class ExtractSummaryResult
extends TextAnalyticsResult {
    private DetectedLanguage detectedLanguage;
    private IterableStream<SummarySentence> sentences;
    private IterableStream<TextAnalyticsWarning> warnings;

    public ExtractSummaryResult(String id, TextDocumentStatistics textDocumentStatistics, TextAnalyticsError error) {
        super(id, textDocumentStatistics, error);
    }

    public DetectedLanguage getDetectedLanguage() {
        return this.detectedLanguage;
    }

    public IterableStream<SummarySentence> getSentences() {
        this.throwExceptionIfError();
        return this.sentences;
    }

    public IterableStream<TextAnalyticsWarning> getWarnings() {
        return this.warnings;
    }

    private void setDetectedLanguage(DetectedLanguage detectedLanguage) {
        this.detectedLanguage = detectedLanguage;
    }

    private void setSentences(IterableStream<SummarySentence> sentences) {
        this.sentences = sentences;
    }

    private void setWarnings(IterableStream<TextAnalyticsWarning> warnings) {
        this.warnings = warnings;
    }

    static {
        ExtractSummaryResultPropertiesHelper.setAccessor(new ExtractSummaryResultPropertiesHelper.ExtractSummaryResultAccessor(){

            @Override
            public void setDetectedLanguage(ExtractSummaryResult documentResult, DetectedLanguage detectedLanguage) {
                documentResult.setDetectedLanguage(detectedLanguage);
            }

            @Override
            public void setSentences(ExtractSummaryResult documentResult, IterableStream<SummarySentence> sentences) {
                documentResult.setSentences((IterableStream<SummarySentence>)sentences);
            }

            @Override
            public void setWarnings(ExtractSummaryResult documentResult, IterableStream<TextAnalyticsWarning> warnings) {
                documentResult.setWarnings((IterableStream<TextAnalyticsWarning>)warnings);
            }
        });
    }
}

