/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ServiceResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.models.ResponseError;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.monitor.query.LogsQueryClientBuilder;
import com.azure.monitor.query.implementation.logs.AzureLogAnalyticsImpl;
import com.azure.monitor.query.implementation.logs.models.BatchQueryRequest;
import com.azure.monitor.query.implementation.logs.models.BatchQueryResponse;
import com.azure.monitor.query.implementation.logs.models.BatchQueryResults;
import com.azure.monitor.query.implementation.logs.models.BatchRequest;
import com.azure.monitor.query.implementation.logs.models.BatchResponse;
import com.azure.monitor.query.implementation.logs.models.ErrorInfo;
import com.azure.monitor.query.implementation.logs.models.ErrorResponseException;
import com.azure.monitor.query.implementation.logs.models.LogsQueryHelper;
import com.azure.monitor.query.implementation.logs.models.QueryBody;
import com.azure.monitor.query.implementation.logs.models.QueryResults;
import com.azure.monitor.query.implementation.logs.models.Table;
import com.azure.monitor.query.models.LogsBatchQuery;
import com.azure.monitor.query.models.LogsBatchQueryResult;
import com.azure.monitor.query.models.LogsBatchQueryResultCollection;
import com.azure.monitor.query.models.LogsQueryOptions;
import com.azure.monitor.query.models.LogsQueryResult;
import com.azure.monitor.query.models.LogsQueryResultStatus;
import com.azure.monitor.query.models.LogsTable;
import com.azure.monitor.query.models.LogsTableCell;
import com.azure.monitor.query.models.LogsTableColumn;
import com.azure.monitor.query.models.LogsTableRow;
import com.azure.monitor.query.models.QueryTimeInterval;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import reactor.core.publisher.Mono;

@ServiceClient(builder=LogsQueryClientBuilder.class, isAsync=true)
public final class LogsQueryAsyncClient {
    private static final String AZURE_RESPONSE_TIMEOUT = "azure-response-timeout";
    private static final int CLIENT_TIMEOUT_BUFFER = 5;
    private final AzureLogAnalyticsImpl innerClient;

    LogsQueryAsyncClient(AzureLogAnalyticsImpl innerClient) {
        this.innerClient = innerClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogsQueryResult> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval) {
        return this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, new LogsQueryOptions()).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<List<T>> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type) {
        return this.queryWorkspace(workspaceId, query, timeInterval).map(result -> LogsQueryHelper.toObject(result.getTable(), type));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<List<T>> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options) {
        return this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options, Context.NONE).map(response -> LogsQueryHelper.toObject(((LogsQueryResult)response.getValue()).getTable(), type));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogsQueryResult>> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options) {
        return FluxUtil.withContext(context -> this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<Response<List<T>>> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options) {
        return this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), LogsQueryHelper.toObject(((LogsQueryResult)response.getValue()).getTable(), type)));
    }

    Mono<LogsBatchQueryResultCollection> queryBatch(String workspaceId, List<String> queries, QueryTimeInterval timeInterval) {
        LogsBatchQuery logsBatchQuery = new LogsBatchQuery();
        queries.forEach(query -> logsBatchQuery.addWorkspaceQuery(workspaceId, (String)query, timeInterval));
        return this.queryBatchWithResponse(logsBatchQuery).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogsBatchQueryResultCollection> queryBatch(LogsBatchQuery logsBatchQuery) {
        return this.queryBatchWithResponse(logsBatchQuery).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogsBatchQueryResultCollection>> queryBatchWithResponse(LogsBatchQuery logsBatchQuery) {
        return this.queryBatchWithResponse(logsBatchQuery, Context.NONE);
    }

    Mono<Response<LogsBatchQueryResultCollection>> queryBatchWithResponse(LogsBatchQuery logsBatchQuery, Context context) {
        List<BatchQueryRequest> requests = LogsQueryHelper.getBatchQueries(logsBatchQuery);
        Duration maxServerTimeout = LogsQueryHelper.getMaxServerTimeout(logsBatchQuery);
        if (maxServerTimeout != null) {
            context = context.addData((Object)AZURE_RESPONSE_TIMEOUT, (Object)maxServerTimeout.plusSeconds(5L));
        }
        BatchRequest batchRequest = new BatchRequest(requests);
        return this.innerClient.getQueries().batchWithResponseAsync(batchRequest, context).onErrorMap(ex -> {
            if (ex instanceof ErrorResponseException) {
                ErrorResponseException error = (ErrorResponseException)((Object)((Object)ex));
                ErrorInfo errorInfo = error.getValue().getError();
                return new HttpResponseException(error.getMessage(), error.getResponse(), (Object)this.mapLogsQueryError(errorInfo));
            }
            return ex;
        }).map(this::convertToLogQueryBatchResult);
    }

    private Context updateContext(Duration serverTimeout, Context context) {
        if (serverTimeout != null) {
            return context.addData((Object)AZURE_RESPONSE_TIMEOUT, (Object)serverTimeout.plusSeconds(5L));
        }
        return context;
    }

    private Response<LogsBatchQueryResultCollection> convertToLogQueryBatchResult(Response<BatchResponse> response) {
        ArrayList<LogsBatchQueryResult> batchResults = new ArrayList<LogsBatchQueryResult>();
        LogsBatchQueryResultCollection logsBatchQueryResultCollection = new LogsBatchQueryResultCollection(batchResults);
        BatchResponse batchResponse = (BatchResponse)response.getValue();
        for (BatchQueryResponse singleQueryResponse : batchResponse.getResponses()) {
            BatchQueryResults queryResults = singleQueryResponse.getBody();
            LogsQueryResult logsQueryResult = this.getLogsQueryResult(queryResults.getTables(), queryResults.getStatistics(), queryResults.getRender(), queryResults.getError());
            LogsBatchQueryResult logsBatchQueryResult = new LogsBatchQueryResult(singleQueryResponse.getId(), singleQueryResponse.getStatus(), logsQueryResult.getAllTables(), logsQueryResult.getStatistics(), logsQueryResult.getVisualization(), logsQueryResult.getError());
            batchResults.add(logsBatchQueryResult);
        }
        batchResults.sort(Comparator.comparingInt(o -> Integer.parseInt(o.getId())));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)logsBatchQueryResultCollection);
    }

    private ResponseError mapLogsQueryError(ErrorInfo errors) {
        if (errors != null) {
            ErrorInfo innerError = errors.getInnererror();
            for (ErrorInfo currentError = errors.getInnererror(); currentError != null; currentError = currentError.getInnererror()) {
                innerError = currentError.getInnererror();
            }
            String code = errors.getCode();
            if (errors.getCode() != null && innerError != null && errors.getCode().equals(innerError.getCode())) {
                code = innerError.getCode();
            }
            return new ResponseError(code, errors.getMessage());
        }
        return null;
    }

    Mono<Response<LogsQueryResult>> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options, Context context) {
        String preferHeader = LogsQueryHelper.buildPreferHeaderString(options);
        context = this.updateContext(options.getServerTimeout(), context);
        QueryBody queryBody = new QueryBody(query);
        if (timeInterval != null) {
            queryBody.setTimespan(LogsQueryHelper.toIso8601Format(timeInterval));
        }
        queryBody.setWorkspaces(this.getAllWorkspaces(options));
        return this.innerClient.getQueries().executeWithResponseAsync(workspaceId, queryBody, preferHeader, context).onErrorMap(ex -> {
            if (ex instanceof ErrorResponseException) {
                ErrorResponseException error = (ErrorResponseException)((Object)((Object)ex));
                ErrorInfo errorInfo = error.getValue().getError();
                return new HttpResponseException(error.getMessage(), error.getResponse(), (Object)this.mapLogsQueryError(errorInfo));
            }
            return ex;
        }).map(this::convertToLogQueryResult).handle((response, sink) -> {
            if (((LogsQueryResult)response.getValue()).getQueryResultStatus() == LogsQueryResultStatus.PARTIAL_FAILURE && !options.isAllowPartialErrors()) {
                sink.error((Throwable)new ServiceResponseException("Query execution returned partial errors. To disable exceptions on partial errors, set setAllowPartialErrors in LogsQueryOptions to true."));
            } else {
                sink.next(response);
            }
        });
    }

    private Response<LogsQueryResult> convertToLogQueryResult(Response<QueryResults> response) {
        QueryResults queryResults = (QueryResults)response.getValue();
        LogsQueryResult logsQueryResult = this.getLogsQueryResult(queryResults.getTables(), queryResults.getStatistics(), queryResults.getRender(), queryResults.getError());
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)logsQueryResult);
    }

    private LogsQueryResult getLogsQueryResult(List<Table> innerTables, Object innerStats, Object innerVisualization, ErrorInfo innerError) {
        ArrayList<LogsTable> tables = null;
        if (innerTables != null) {
            tables = new ArrayList<LogsTable>();
            for (Table table : innerTables) {
                ArrayList<LogsTableCell> tableCells = new ArrayList<LogsTableCell>();
                ArrayList<LogsTableRow> tableRows = new ArrayList<LogsTableRow>();
                ArrayList<LogsTableColumn> tableColumns = new ArrayList<LogsTableColumn>();
                LogsTable logsTable = new LogsTable(tableCells, tableRows, tableColumns);
                tables.add(logsTable);
                List<List<Object>> rows = table.getRows();
                for (int i = 0; i < rows.size(); ++i) {
                    List<Object> row = rows.get(i);
                    LogsTableRow tableRow = new LogsTableRow(i, new ArrayList<LogsTableCell>());
                    tableRows.add(tableRow);
                    for (int j = 0; j < row.size(); ++j) {
                        LogsTableCell cell = new LogsTableCell(table.getColumns().get(j).getName(), table.getColumns().get(j).getType(), j, i, row.get(j));
                        tableCells.add(cell);
                        tableRow.getRow().add(cell);
                    }
                }
            }
        }
        BinaryData queryStatistics = null;
        if (innerStats != null) {
            queryStatistics = BinaryData.fromObject((Object)innerStats);
        }
        BinaryData queryVisualization = null;
        if (innerVisualization != null) {
            queryVisualization = BinaryData.fromObject((Object)innerVisualization);
        }
        LogsQueryResult logsQueryResult = new LogsQueryResult(tables, queryStatistics, queryVisualization, this.mapLogsQueryError(innerError));
        return logsQueryResult;
    }

    private List<String> getAllWorkspaces(LogsQueryOptions body) {
        ArrayList<String> allWorkspaces = new ArrayList<String>();
        if (!CoreUtils.isNullOrEmpty(body.getAdditionalWorkspaces())) {
            allWorkspaces.addAll(body.getAdditionalWorkspaces());
        }
        return allWorkspaces;
    }
}

