/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.monitor.query.MetricsQueryAsyncClient;
import com.azure.monitor.query.MetricsQueryClientBuilder;
import com.azure.monitor.query.models.MetricDefinition;
import com.azure.monitor.query.models.MetricNamespace;
import com.azure.monitor.query.models.MetricsQueryOptions;
import com.azure.monitor.query.models.MetricsQueryResult;
import java.time.OffsetDateTime;
import java.util.List;

@ServiceClient(builder=MetricsQueryClientBuilder.class)
public final class MetricsQueryClient {
    private final MetricsQueryAsyncClient asyncClient;

    MetricsQueryClient(MetricsQueryAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricsQueryResult queryResource(String resourceUri, List<String> metricsNames) {
        return (MetricsQueryResult)this.queryResourceWithResponse(resourceUri, metricsNames, new MetricsQueryOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetricsQueryResult> queryResourceWithResponse(String resourceUri, List<String> metricsNames, MetricsQueryOptions options, Context context) {
        return (Response)this.asyncClient.queryResourceWithResponse(resourceUri, metricsNames, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricNamespace> listMetricNamespaces(String resourceUri, OffsetDateTime startTime) {
        return this.listMetricNamespaces(resourceUri, startTime, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricNamespace> listMetricNamespaces(String resourceUri, OffsetDateTime startTime, Context context) {
        return new PagedIterable(this.asyncClient.listMetricNamespaces(resourceUri, startTime, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricDefinition> listMetricDefinitions(String resourceUri) {
        return this.listMetricDefinitions(resourceUri, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricDefinition> listMetricDefinitions(String resourceUri, String metricsNamespace, Context context) {
        return new PagedIterable(this.asyncClient.listMetricDefinitions(resourceUri, metricsNamespace, context));
    }
}

