/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query.implementation.metrics.models;

import com.azure.monitor.query.implementation.metrics.models.LocalizableString;
import com.azure.monitor.query.implementation.metrics.models.TimeSeriesElement;
import com.azure.monitor.query.models.MetricUnit;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Metric {
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="type", required=true)
    private String type;
    @JsonProperty(value="name", required=true)
    private LocalizableString name;
    @JsonProperty(value="displayDescription")
    private String displayDescription;
    @JsonProperty(value="errorCode")
    private String errorCode;
    @JsonProperty(value="errorMessage")
    private String errorMessage;
    @JsonProperty(value="unit", required=true)
    private MetricUnit unit;
    @JsonProperty(value="timeseries", required=true)
    private List<TimeSeriesElement> timeseries;

    @JsonCreator
    public Metric(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="type", required=true) String type, @JsonProperty(value="name", required=true) LocalizableString name, @JsonProperty(value="unit", required=true) MetricUnit unit, @JsonProperty(value="timeseries", required=true) List<TimeSeriesElement> timeseries) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.unit = unit;
        this.timeseries = timeseries;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public LocalizableString getName() {
        return this.name;
    }

    public String getDisplayDescription() {
        return this.displayDescription;
    }

    public Metric setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Metric setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Metric setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    public List<TimeSeriesElement> getTimeseries() {
        return this.timeseries;
    }

    public void validate() {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Missing required property id in model Metric");
        }
        if (this.getType() == null) {
            throw new IllegalArgumentException("Missing required property type in model Metric");
        }
        if (this.getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model Metric");
        }
        this.getName().validate();
        if (this.getUnit() == null) {
            throw new IllegalArgumentException("Missing required property unit in model Metric");
        }
        if (this.getTimeseries() == null) {
            throw new IllegalArgumentException("Missing required property timeseries in model Metric");
        }
        this.getTimeseries().forEach(e -> e.validate());
    }
}

