/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.security.keyvault.keys.cryptography.Aes128Cbc;
import com.azure.security.keyvault.keys.cryptography.Aes128CbcHmacSha256;
import com.azure.security.keyvault.keys.cryptography.Aes192Cbc;
import com.azure.security.keyvault.keys.cryptography.Aes192CbcHmacSha384;
import com.azure.security.keyvault.keys.cryptography.Aes256Cbc;
import com.azure.security.keyvault.keys.cryptography.Aes256CbcHmacSha512;
import com.azure.security.keyvault.keys.cryptography.AesKw128;
import com.azure.security.keyvault.keys.cryptography.AesKw192;
import com.azure.security.keyvault.keys.cryptography.AesKw256;
import com.azure.security.keyvault.keys.cryptography.Algorithm;
import com.azure.security.keyvault.keys.cryptography.Es256;
import com.azure.security.keyvault.keys.cryptography.Es256k;
import com.azure.security.keyvault.keys.cryptography.Es384;
import com.azure.security.keyvault.keys.cryptography.Es512;
import com.azure.security.keyvault.keys.cryptography.Rsa15;
import com.azure.security.keyvault.keys.cryptography.RsaOaep;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class AlgorithmResolver {
    public static final AlgorithmResolver Default = new AlgorithmResolver();
    private final Map<String, Algorithm> algorithms = new ConcurrentHashMap<String, Algorithm>();

    AlgorithmResolver() {
    }

    public Algorithm get(String algorithmName) {
        return this.algorithms.get(algorithmName);
    }

    public void put(String algorithmName, Algorithm provider) {
        this.algorithms.put(algorithmName, provider);
    }

    public void remove(String algorithmName) {
        this.algorithms.remove(algorithmName);
    }

    static {
        Default.put("A128CBC-HS256", new Aes128CbcHmacSha256());
        Default.put("A192CBC-HS384", new Aes192CbcHmacSha384());
        Default.put("A256CBC-HS512", new Aes256CbcHmacSha512());
        Default.put("A128CBC", new Aes128Cbc());
        Default.put("A192CBC", new Aes192Cbc());
        Default.put("A256CBC", new Aes256Cbc());
        Default.put("A128KW", new AesKw128());
        Default.put("A192KW", new AesKw192());
        Default.put("A256KW", new AesKw256());
        Default.put("RSA1_5", new Rsa15());
        Default.put("RSA-OAEP", new RsaOaep());
        Default.put("ES256K", new Es256k());
        Default.put("ES256", new Es256());
        Default.put("ES384", new Es384());
        Default.put("ES512", new Es512());
    }
}

