/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.WebTestsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.WebTestInner;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.implementation.WebTestImpl;
import com.azure.resourcemanager.applicationinsights.models.WebTest;
import com.azure.resourcemanager.applicationinsights.models.WebTests;

public final class WebTestsImpl
implements WebTests {
    private static final ClientLogger LOGGER = new ClientLogger(WebTestsImpl.class);
    private final WebTestsClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public WebTestsImpl(WebTestsClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<WebTest> listByResourceGroup(String resourceGroupName) {
        PagedIterable<WebTestInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new WebTestImpl((WebTestInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WebTest> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<WebTestInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new WebTestImpl((WebTestInner)((Object)inner1), this.manager()));
    }

    @Override
    public WebTest getByResourceGroup(String resourceGroupName, String webTestName) {
        WebTestInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, webTestName);
        if (inner != null) {
            return new WebTestImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<WebTest> getByResourceGroupWithResponse(String resourceGroupName, String webTestName, Context context) {
        Response<WebTestInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, webTestName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WebTestImpl((WebTestInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String webTestName) {
        this.serviceClient().delete(resourceGroupName, webTestName);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String webTestName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, webTestName, context);
    }

    @Override
    public PagedIterable<WebTest> list() {
        PagedIterable<WebTestInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new WebTestImpl((WebTestInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WebTest> list(Context context) {
        PagedIterable<WebTestInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new WebTestImpl((WebTestInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WebTest> listByComponent(String componentName, String resourceGroupName) {
        PagedIterable<WebTestInner> inner = this.serviceClient().listByComponent(componentName, resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new WebTestImpl((WebTestInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WebTest> listByComponent(String componentName, String resourceGroupName, Context context) {
        PagedIterable<WebTestInner> inner = this.serviceClient().listByComponent(componentName, resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new WebTestImpl((WebTestInner)((Object)inner1), this.manager()));
    }

    @Override
    public WebTest getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String webTestName = Utils.getValueFromIdByName(id, "webtests");
        if (webTestName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'webtests'.", id)));
        }
        return (WebTest)this.getByResourceGroupWithResponse(resourceGroupName, webTestName, Context.NONE).getValue();
    }

    @Override
    public Response<WebTest> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String webTestName = Utils.getValueFromIdByName(id, "webtests");
        if (webTestName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'webtests'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, webTestName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String webTestName = Utils.getValueFromIdByName(id, "webtests");
        if (webTestName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'webtests'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, webTestName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String webTestName = Utils.getValueFromIdByName(id, "webtests");
        if (webTestName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'webtests'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, webTestName, context);
    }

    private WebTestsClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public WebTestImpl define(String name) {
        return new WebTestImpl(name, this.manager());
    }
}

