/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookInner;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.models.Workbook;
import com.azure.resourcemanager.applicationinsights.models.WorkbookResourceIdentity;
import com.azure.resourcemanager.applicationinsights.models.WorkbookSharedTypeKind;
import com.azure.resourcemanager.applicationinsights.models.WorkbookUpdateParameters;
import com.azure.resourcemanager.applicationinsights.models.WorkbookUpdateSharedTypeKind;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class WorkbookImpl
implements Workbook,
Workbook.Definition,
Workbook.Update {
    private WorkbookInner innerObject;
    private final ApplicationInsightsManager serviceManager;
    private String resourceGroupName;
    private String resourceName;
    private String createSourceId;
    private String updateSourceId;
    private WorkbookUpdateParameters updateWorkbookUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public WorkbookResourceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public WorkbookSharedTypeKind kind() {
        return this.innerModel().kind();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String serializedData() {
        return this.innerModel().serializedData();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public OffsetDateTime timeModified() {
        return this.innerModel().timeModified();
    }

    @Override
    public String category() {
        return this.innerModel().category();
    }

    @Override
    public List<String> tagsPropertiesTags() {
        List<String> inner = this.innerModel().tagsPropertiesTags();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String userId() {
        return this.innerModel().userId();
    }

    @Override
    public String sourceId() {
        return this.innerModel().sourceId();
    }

    @Override
    public String storageUri() {
        return this.innerModel().storageUri();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String revision() {
        return this.innerModel().revision();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WorkbookInner innerModel() {
        return this.innerObject;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkbookImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Workbook create() {
        this.innerObject = (WorkbookInner)((Object)this.serviceManager.serviceClient().getWorkbooks().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), this.createSourceId, Context.NONE).getValue());
        return this;
    }

    @Override
    public Workbook create(Context context) {
        this.innerObject = (WorkbookInner)((Object)this.serviceManager.serviceClient().getWorkbooks().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), this.createSourceId, context).getValue());
        return this;
    }

    WorkbookImpl(String name, ApplicationInsightsManager serviceManager) {
        this.innerObject = new WorkbookInner();
        this.serviceManager = serviceManager;
        this.resourceName = name;
        this.createSourceId = null;
    }

    @Override
    public WorkbookImpl update() {
        this.updateSourceId = null;
        this.updateWorkbookUpdateParameters = new WorkbookUpdateParameters();
        return this;
    }

    @Override
    public Workbook apply() {
        this.innerObject = (WorkbookInner)((Object)this.serviceManager.serviceClient().getWorkbooks().updateWithResponse(this.resourceGroupName, this.resourceName, this.updateSourceId, this.updateWorkbookUpdateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Workbook apply(Context context) {
        this.innerObject = (WorkbookInner)((Object)this.serviceManager.serviceClient().getWorkbooks().updateWithResponse(this.resourceGroupName, this.resourceName, this.updateSourceId, this.updateWorkbookUpdateParameters, context).getValue());
        return this;
    }

    WorkbookImpl(WorkbookInner innerObject, ApplicationInsightsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = Utils.getValueFromIdByName(innerObject.id(), "workbooks");
    }

    @Override
    public Workbook refresh() {
        Boolean localCanFetchContent = null;
        this.innerObject = (WorkbookInner)((Object)this.serviceManager.serviceClient().getWorkbooks().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, localCanFetchContent, Context.NONE).getValue());
        return this;
    }

    @Override
    public Workbook refresh(Context context) {
        Boolean localCanFetchContent = null;
        this.innerObject = (WorkbookInner)((Object)this.serviceManager.serviceClient().getWorkbooks().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, localCanFetchContent, context).getValue());
        return this;
    }

    @Override
    public WorkbookImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public WorkbookImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public WorkbookImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateWorkbookUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public WorkbookImpl withIdentity(WorkbookResourceIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public WorkbookImpl withKind(WorkbookSharedTypeKind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public WorkbookImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public WorkbookImpl withDisplayName(String displayName) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        }
        this.updateWorkbookUpdateParameters.withDisplayName(displayName);
        return this;
    }

    @Override
    public WorkbookImpl withSerializedData(String serializedData) {
        if (this.isInCreateMode()) {
            this.innerModel().withSerializedData(serializedData);
            return this;
        }
        this.updateWorkbookUpdateParameters.withSerializedData(serializedData);
        return this;
    }

    @Override
    public WorkbookImpl withVersion(String version) {
        this.innerModel().withVersion(version);
        return this;
    }

    @Override
    public WorkbookImpl withCategory(String category) {
        if (this.isInCreateMode()) {
            this.innerModel().withCategory(category);
            return this;
        }
        this.updateWorkbookUpdateParameters.withCategory(category);
        return this;
    }

    @Override
    public WorkbookImpl withTagsPropertiesTags(List<String> tagsPropertiesTags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTagsPropertiesTags(tagsPropertiesTags);
            return this;
        }
        this.updateWorkbookUpdateParameters.withTagsPropertiesTags(tagsPropertiesTags);
        return this;
    }

    @Override
    public WorkbookImpl withSourceId(String sourceId) {
        if (this.isInCreateMode()) {
            this.innerModel().withSourceId(sourceId);
            return this;
        }
        this.updateSourceId = sourceId;
        return this;
    }

    @Override
    public WorkbookImpl withStorageUri(String storageUri) {
        this.innerModel().withStorageUri(storageUri);
        return this;
    }

    @Override
    public WorkbookImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateWorkbookUpdateParameters.withDescription(description);
        return this;
    }

    @Override
    public WorkbookImpl withSourceIdParameter(String sourceId) {
        this.createSourceId = sourceId;
        return this;
    }

    @Override
    public WorkbookImpl withKind(WorkbookUpdateSharedTypeKind kind) {
        this.updateWorkbookUpdateParameters.withKind(kind);
        return this;
    }

    @Override
    public WorkbookImpl withRevision(String revision) {
        this.updateWorkbookUpdateParameters.withRevision(revision);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

