// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.models.MongoDBCollectionGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.MongoDBDatabaseGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsGetResultsInner;
import com.azure.resourcemanager.cosmos.models.MongoDBCollectionCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in MongoDBResourcesClient. */
public interface MongoDBResourcesClient {
    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MongoDBDatabaseGetResultsInner> listMongoDBDatabasesAsync(String resourceGroupName, String accountName);

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MongoDBDatabaseGetResultsInner> listMongoDBDatabases(String resourceGroupName, String accountName);

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MongoDBDatabaseGetResultsInner> listMongoDBDatabases(
        String resourceGroupName, String accountName, Context context);

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MongoDBDatabaseGetResultsInner>> getMongoDBDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MongoDBDatabaseGetResultsInner> getMongoDBDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MongoDBDatabaseGetResultsInner getMongoDBDatabase(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MongoDBDatabaseGetResultsInner> getMongoDBDatabaseWithResponse(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters Parameters to create and update Cosmos DB MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateMongoDBDatabaseWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters);

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters Parameters to create and update Cosmos DB MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>
        beginCreateUpdateMongoDBDatabaseAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters);

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters Parameters to create and update Cosmos DB MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>
        beginCreateUpdateMongoDBDatabase(
            String resourceGroupName,
            String accountName,
            String databaseName,
            MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters);

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters Parameters to create and update Cosmos DB MongoDB database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>
        beginCreateUpdateMongoDBDatabase(
            String resourceGroupName,
            String accountName,
            String databaseName,
            MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters,
            Context context);

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters Parameters to create and update Cosmos DB MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MongoDBDatabaseGetResultsInner> createUpdateMongoDBDatabaseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters);

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters Parameters to create and update Cosmos DB MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MongoDBDatabaseGetResultsInner createUpdateMongoDBDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters);

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters Parameters to create and update Cosmos DB MongoDB database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MongoDBDatabaseGetResultsInner createUpdateMongoDBDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteMongoDBDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteMongoDBDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteMongoDBDatabase(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteMongoDBDatabase(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteMongoDBDatabase(String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteMongoDBDatabase(String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ThroughputSettingsGetResultsInner>> getMongoDBDatabaseThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> getMongoDBDatabaseThroughputAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner getMongoDBDatabaseThroughput(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ThroughputSettingsGetResultsInner> getMongoDBDatabaseThroughputWithResponse(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateMongoDBDatabaseThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBDatabaseThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBDatabaseThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBDatabaseThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context);

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> updateMongoDBDatabaseThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner updateMongoDBDatabaseThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner updateMongoDBDatabaseThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context);

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB collections and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MongoDBCollectionGetResultsInner> listMongoDBCollectionsAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB collections and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MongoDBCollectionGetResultsInner> listMongoDBCollections(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB collections and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MongoDBCollectionGetResultsInner> listMongoDBCollections(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB collection under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MongoDBCollectionGetResultsInner>> getMongoDBCollectionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB collection under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MongoDBCollectionGetResultsInner> getMongoDBCollectionAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB collection under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MongoDBCollectionGetResultsInner getMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB collection under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MongoDBCollectionGetResultsInner> getMongoDBCollectionWithResponse(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context);

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters Parameters to create and update Cosmos DB MongoDB collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateMongoDBCollectionWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters);

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters Parameters to create and update Cosmos DB MongoDB collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>
        beginCreateUpdateMongoDBCollectionAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters);

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters Parameters to create and update Cosmos DB MongoDB collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>
        beginCreateUpdateMongoDBCollection(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters);

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters Parameters to create and update Cosmos DB MongoDB collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>
        beginCreateUpdateMongoDBCollection(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters,
            Context context);

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters Parameters to create and update Cosmos DB MongoDB collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MongoDBCollectionGetResultsInner> createUpdateMongoDBCollectionAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters);

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters Parameters to create and update Cosmos DB MongoDB collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MongoDBCollectionGetResultsInner createUpdateMongoDBCollection(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters);

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters Parameters to create and update Cosmos DB MongoDB collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MongoDBCollectionGetResultsInner createUpdateMongoDBCollection(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteMongoDBCollectionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteMongoDBCollectionAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteMongoDBCollectionAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context);

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ThroughputSettingsGetResultsInner>> getMongoDBCollectionThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> getMongoDBCollectionThroughputAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner getMongoDBCollectionThroughput(
        String resourceGroupName, String accountName, String databaseName, String collectionName);

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ThroughputSettingsGetResultsInner> getMongoDBCollectionThroughputWithResponse(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context);

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateMongoDBCollectionThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBCollectionThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBCollectionThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBCollectionThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context);

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> updateMongoDBCollectionThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner updateMongoDBCollectionThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner updateMongoDBCollectionThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context);
}
