// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.GremlinResourcesClient;
import com.azure.resourcemanager.cosmos.fluent.models.GremlinDatabaseGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.GremlinGraphGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsGetResultsInner;
import com.azure.resourcemanager.cosmos.models.GremlinDatabaseCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.GremlinDatabaseListResult;
import com.azure.resourcemanager.cosmos.models.GremlinGraphCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.GremlinGraphListResult;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in GremlinResourcesClient. */
public final class GremlinResourcesClientImpl implements GremlinResourcesClient {
    private final ClientLogger logger = new ClientLogger(GremlinResourcesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final GremlinResourcesService service;

    /** The service client containing this operation class. */
    private final CosmosDBManagementClientImpl client;

    /**
     * Initializes an instance of GremlinResourcesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    GremlinResourcesClientImpl(CosmosDBManagementClientImpl client) {
        this.service =
            RestProxy.create(GremlinResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CosmosDBManagementClientGremlinResources to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CosmosDBManagementCl")
    private interface GremlinResourcesService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GremlinDatabaseListResult>> listGremlinDatabases(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GremlinDatabaseGetResultsInner>> getGremlinDatabase(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinDatabase(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        @ExpectedResponses({202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteGremlinDatabase(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateGremlinDatabaseThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GremlinGraphListResult>> listGremlinGraphs(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GremlinGraphGetResultsInner>> getGremlinGraph(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinGraph(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        @ExpectedResponses({202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteGremlinGraph(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}"
                + "/throughputSettings/default")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}"
                + "/throughputSettings/default")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateGremlinGraphThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context);
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GremlinDatabaseGetResultsInner>> listGremlinDatabasesSinglePageAsync(
        String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listGremlinDatabases(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            apiVersion,
                            context))
            .<PagedResponse<GremlinDatabaseGetResultsInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GremlinDatabaseGetResultsInner>> listGremlinDatabasesSinglePageAsync(
        String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .listGremlinDatabases(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GremlinDatabaseGetResultsInner> listGremlinDatabasesAsync(
        String resourceGroupName, String accountName) {
        return new PagedFlux<>(() -> listGremlinDatabasesSinglePageAsync(resourceGroupName, accountName));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GremlinDatabaseGetResultsInner> listGremlinDatabasesAsync(
        String resourceGroupName, String accountName, Context context) {
        return new PagedFlux<>(() -> listGremlinDatabasesSinglePageAsync(resourceGroupName, accountName, context));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GremlinDatabaseGetResultsInner> listGremlinDatabases(
        String resourceGroupName, String accountName) {
        return new PagedIterable<>(listGremlinDatabasesAsync(resourceGroupName, accountName));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GremlinDatabaseGetResultsInner> listGremlinDatabases(
        String resourceGroupName, String accountName, Context context) {
        return new PagedIterable<>(listGremlinDatabasesAsync(resourceGroupName, accountName, context));
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GremlinDatabaseGetResultsInner>> getGremlinDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getGremlinDatabase(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GremlinDatabaseGetResultsInner>> getGremlinDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .getGremlinDatabase(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                apiVersion,
                context);
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GremlinDatabaseGetResultsInner> getGremlinDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        return getGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName)
            .flatMap(
                (Response<GremlinDatabaseGetResultsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinDatabaseGetResultsInner getGremlinDatabase(
        String resourceGroupName, String accountName, String databaseName) {
        return getGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GremlinDatabaseGetResultsInner> getGremlinDatabaseWithResponse(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return getGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinDatabaseWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter createUpdateGremlinDatabaseParameters is required and cannot be null."));
        } else {
            createUpdateGremlinDatabaseParameters.validate();
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createUpdateGremlinDatabase(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            apiVersion,
                            createUpdateGremlinDatabaseParameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinDatabaseWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter createUpdateGremlinDatabaseParameters is required and cannot be null."));
        } else {
            createUpdateGremlinDatabaseParameters.validate();
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .createUpdateGremlinDatabase(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                apiVersion,
                createUpdateGremlinDatabaseParameters,
                context);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>
        beginCreateUpdateGremlinDatabaseAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createUpdateGremlinDatabaseWithResponseAsync(
                resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters);
        return this
            .client
            .<GremlinDatabaseGetResultsInner, GremlinDatabaseGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GremlinDatabaseGetResultsInner.class,
                GremlinDatabaseGetResultsInner.class,
                Context.NONE);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>
        beginCreateUpdateGremlinDatabaseAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createUpdateGremlinDatabaseWithResponseAsync(
                resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters, context);
        return this
            .client
            .<GremlinDatabaseGetResultsInner, GremlinDatabaseGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GremlinDatabaseGetResultsInner.class,
                GremlinDatabaseGetResultsInner.class,
                context);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>
        beginCreateUpdateGremlinDatabase(
            String resourceGroupName,
            String accountName,
            String databaseName,
            GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return beginCreateUpdateGremlinDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>
        beginCreateUpdateGremlinDatabase(
            String resourceGroupName,
            String accountName,
            String databaseName,
            GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters,
            Context context) {
        return beginCreateUpdateGremlinDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters, context)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GremlinDatabaseGetResultsInner> createUpdateGremlinDatabaseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return beginCreateUpdateGremlinDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GremlinDatabaseGetResultsInner> createUpdateGremlinDatabaseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters,
        Context context) {
        return beginCreateUpdateGremlinDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinDatabaseGetResultsInner createUpdateGremlinDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return createUpdateGremlinDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters)
            .block();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters Parameters to create and update Cosmos DB Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinDatabaseGetResultsInner createUpdateGremlinDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters,
        Context context) {
        return createUpdateGremlinDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateGremlinDatabaseParameters, context)
            .block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteGremlinDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteGremlinDatabase(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteGremlinDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .deleteGremlinDatabase(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                apiVersion,
                context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteGremlinDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteGremlinDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinDatabase(
        String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinDatabase(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, context).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteGremlinDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        deleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteGremlinDatabase(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        deleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getGremlinDatabaseThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .getGremlinDatabaseThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                apiVersion,
                context);
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> getGremlinDatabaseThroughputAsync(
        String resourceGroupName, String accountName, String databaseName) {
        return getGremlinDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName)
            .flatMap(
                (Response<ThroughputSettingsGetResultsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner getGremlinDatabaseThroughput(
        String resourceGroupName, String accountName, String databaseName) {
        return getGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ThroughputSettingsGetResultsInner> getGremlinDatabaseThroughputWithResponse(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return getGremlinDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, context)
            .block();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateGremlinDatabaseThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateGremlinDatabaseThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            apiVersion,
                            updateThroughputParameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateGremlinDatabaseThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .updateGremlinDatabaseThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                apiVersion,
                updateThroughputParameters,
                context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinDatabaseThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateGremlinDatabaseThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                Context.NONE);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinDatabaseThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateGremlinDatabaseThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters, context);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinDatabaseThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateGremlinDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinDatabaseThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context) {
        return beginUpdateGremlinDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters, context)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> updateGremlinDatabaseThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateGremlinDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> updateGremlinDatabaseThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return beginUpdateGremlinDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateGremlinDatabaseThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateGremlinDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters)
            .block();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateGremlinDatabaseThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return updateGremlinDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters, context)
            .block();
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GremlinGraphGetResultsInner>> listGremlinGraphsSinglePageAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listGremlinGraphs(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            apiVersion,
                            context))
            .<PagedResponse<GremlinGraphGetResultsInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GremlinGraphGetResultsInner>> listGremlinGraphsSinglePageAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .listGremlinGraphs(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                apiVersion,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GremlinGraphGetResultsInner> listGremlinGraphsAsync(
        String resourceGroupName, String accountName, String databaseName) {
        return new PagedFlux<>(() -> listGremlinGraphsSinglePageAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GremlinGraphGetResultsInner> listGremlinGraphsAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return new PagedFlux<>(
            () -> listGremlinGraphsSinglePageAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GremlinGraphGetResultsInner> listGremlinGraphs(
        String resourceGroupName, String accountName, String databaseName) {
        return new PagedIterable<>(listGremlinGraphsAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GremlinGraphGetResultsInner> listGremlinGraphs(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return new PagedIterable<>(listGremlinGraphsAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GremlinGraphGetResultsInner>> getGremlinGraphWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getGremlinGraph(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            graphName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GremlinGraphGetResultsInner>> getGremlinGraphWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .getGremlinGraph(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                graphName,
                apiVersion,
                context);
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GremlinGraphGetResultsInner> getGremlinGraphAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        return getGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName)
            .flatMap(
                (Response<GremlinGraphGetResultsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinGraphGetResultsInner getGremlinGraph(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        return getGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName).block();
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GremlinGraphGetResultsInner> getGremlinGraphWithResponse(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return getGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, context)
            .block();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinGraphWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (createUpdateGremlinGraphParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter createUpdateGremlinGraphParameters is required and cannot be null."));
        } else {
            createUpdateGremlinGraphParameters.validate();
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createUpdateGremlinGraph(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            graphName,
                            apiVersion,
                            createUpdateGremlinGraphParameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinGraphWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (createUpdateGremlinGraphParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter createUpdateGremlinGraphParameters is required and cannot be null."));
        } else {
            createUpdateGremlinGraphParameters.validate();
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .createUpdateGremlinGraph(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                graphName,
                apiVersion,
                createUpdateGremlinGraphParameters,
                context);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>
        beginCreateUpdateGremlinGraphAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String graphName,
            GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createUpdateGremlinGraphWithResponseAsync(
                resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters);
        return this
            .client
            .<GremlinGraphGetResultsInner, GremlinGraphGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GremlinGraphGetResultsInner.class,
                GremlinGraphGetResultsInner.class,
                Context.NONE);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>
        beginCreateUpdateGremlinGraphAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String graphName,
            GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createUpdateGremlinGraphWithResponseAsync(
                resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters, context);
        return this
            .client
            .<GremlinGraphGetResultsInner, GremlinGraphGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                GremlinGraphGetResultsInner.class,
                GremlinGraphGetResultsInner.class,
                context);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>
        beginCreateUpdateGremlinGraph(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String graphName,
            GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return beginCreateUpdateGremlinGraphAsync(
                resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>
        beginCreateUpdateGremlinGraph(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String graphName,
            GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters,
            Context context) {
        return beginCreateUpdateGremlinGraphAsync(
                resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters, context)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GremlinGraphGetResultsInner> createUpdateGremlinGraphAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return beginCreateUpdateGremlinGraphAsync(
                resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GremlinGraphGetResultsInner> createUpdateGremlinGraphAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters,
        Context context) {
        return beginCreateUpdateGremlinGraphAsync(
                resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinGraphGetResultsInner createUpdateGremlinGraph(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return createUpdateGremlinGraphAsync(
                resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters)
            .block();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters Parameters to create and update Cosmos DB Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinGraphGetResultsInner createUpdateGremlinGraph(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters,
        Context context) {
        return createUpdateGremlinGraphAsync(
                resourceGroupName, accountName, databaseName, graphName, createUpdateGremlinGraphParameters, context)
            .block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteGremlinGraphWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteGremlinGraph(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            graphName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteGremlinGraphWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .deleteGremlinGraph(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                graphName,
                apiVersion,
                context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteGremlinGraphAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteGremlinGraphAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinGraph(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        return beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinGraph(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, context)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteGremlinGraphAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        return beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteGremlinGraphAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteGremlinGraph(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        deleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteGremlinGraph(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        deleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, context).block();
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getGremlinGraphThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            graphName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .getGremlinGraphThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                graphName,
                apiVersion,
                context);
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> getGremlinGraphThroughputAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        return getGremlinGraphThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, graphName)
            .flatMap(
                (Response<ThroughputSettingsGetResultsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner getGremlinGraphThroughput(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        return getGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName).block();
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ThroughputSettingsGetResultsInner> getGremlinGraphThroughputWithResponse(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        return getGremlinGraphThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, graphName, context)
            .block();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateGremlinGraphThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String apiVersion = "2019-08-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateGremlinGraphThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            graphName,
                            apiVersion,
                            updateThroughputParameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateGremlinGraphThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return service
            .updateGremlinGraphThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                graphName,
                apiVersion,
                updateThroughputParameters,
                context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinGraphThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String graphName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateGremlinGraphThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                Context.NONE);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinGraphThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String graphName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateGremlinGraphThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters, context);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinGraphThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String graphName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateGremlinGraphThroughputAsync(
                resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinGraphThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String graphName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context) {
        return beginUpdateGremlinGraphThroughputAsync(
                resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters, context)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> updateGremlinGraphThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateGremlinGraphThroughputAsync(
                resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> updateGremlinGraphThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return beginUpdateGremlinGraphThroughputAsync(
                resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateGremlinGraphThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateGremlinGraphThroughputAsync(
                resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters)
            .block();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName Name of an Azure resource group.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters Parameters to update Cosmos DB resource throughput.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateGremlinGraphThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return updateGremlinGraphThroughputAsync(
                resourceGroupName, accountName, databaseName, graphName, updateThroughputParameters, context)
            .block();
    }
}
