// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Cosmos DB Cassandra table partition key. */
@Fluent
public final class CassandraPartitionKey {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CassandraPartitionKey.class);

    /*
     * Name of the Cosmos DB Cassandra table partition key
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Get the name property: Name of the Cosmos DB Cassandra table partition key.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Cosmos DB Cassandra table partition key.
     *
     * @param name the name value to set.
     * @return the CassandraPartitionKey object itself.
     */
    public CassandraPartitionKey withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
