/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.cosmos.CosmosManager;
import com.azure.resourcemanager.cosmos.fluent.CosmosDBManagementClient;
import com.azure.resourcemanager.cosmos.fluent.DatabaseAccountsClient;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountListConnectionStringsResultInner;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountListKeysResultInner;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseAccountListReadOnlyKeysResultInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBAccountImpl;
import com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListConnectionStringsResultImpl;
import com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListKeysResultImpl;
import com.azure.resourcemanager.cosmos.implementation.DatabaseAccountListReadOnlyKeysResultImpl;
import com.azure.resourcemanager.cosmos.models.CosmosDBAccount;
import com.azure.resourcemanager.cosmos.models.CosmosDBAccounts;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountListConnectionStringsResult;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountListKeysResult;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountListReadOnlyKeysResult;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountRegenerateKeyParameters;
import com.azure.resourcemanager.cosmos.models.FailoverPolicies;
import com.azure.resourcemanager.cosmos.models.FailoverPolicy;
import com.azure.resourcemanager.cosmos.models.KeyKind;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Mono;

public class CosmosDBAccountsImpl
extends GroupableResourcesImpl<CosmosDBAccount, CosmosDBAccountImpl, DatabaseAccountGetResultsInner, DatabaseAccountsClient, CosmosManager>
implements CosmosDBAccounts {
    public CosmosDBAccountsImpl(CosmosManager manager) {
        super((Object)((CosmosDBManagementClient)manager.serviceClient()).getDatabaseAccounts(), (Manager)manager);
    }

    public PagedIterable<CosmosDBAccount> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<CosmosDBAccount> listAsync() {
        return ((DatabaseAccountsClient)this.inner()).listAsync().mapPage(inner -> new CosmosDBAccountImpl(inner.name(), (DatabaseAccountGetResultsInner)((Object)inner), (CosmosManager)this.manager()));
    }

    public PagedFlux<CosmosDBAccount> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((DatabaseAccountsClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    public PagedIterable<CosmosDBAccount> listByResourceGroup(String groupName) {
        return this.wrapList(((DatabaseAccountsClient)this.inner()).listByResourceGroup(groupName));
    }

    protected Mono<DatabaseAccountGetResultsInner> getInnerAsync(String resourceGroupName, String name) {
        return ((DatabaseAccountsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    public CosmosDBAccountImpl define(String name) {
        return this.wrapModel(name);
    }

    protected Mono<Void> deleteInnerAsync(String groupName, String name) {
        return ((DatabaseAccountsClient)this.inner()).deleteAsync(groupName, name);
    }

    protected CosmosDBAccountImpl wrapModel(String name) {
        return new CosmosDBAccountImpl(name, new DatabaseAccountGetResultsInner(), (CosmosManager)this.manager());
    }

    protected CosmosDBAccountImpl wrapModel(DatabaseAccountGetResultsInner containerServiceInner) {
        if (containerServiceInner == null) {
            return null;
        }
        return new CosmosDBAccountImpl(containerServiceInner.name(), containerServiceInner, (CosmosManager)this.manager());
    }

    @Override
    public void failoverPriorityChange(String groupName, String accountName, List<Location> failoverLocations) {
        this.failoverPriorityChangeAsync(groupName, accountName, failoverLocations).block();
    }

    @Override
    public Mono<Void> failoverPriorityChangeAsync(String groupName, String accountName, List<Location> failoverLocations) {
        ArrayList<FailoverPolicy> policyInners = new ArrayList<FailoverPolicy>();
        for (int i = 0; i < failoverLocations.size(); ++i) {
            Location location = failoverLocations.get(i);
            FailoverPolicy policyInner = new FailoverPolicy();
            policyInner.withLocationName(location.locationName());
            policyInner.withFailoverPriority(i);
            policyInners.add(policyInner);
        }
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().failoverPriorityChangeAsync(groupName, accountName, new FailoverPolicies().withFailoverPolicies(policyInners));
    }

    @Override
    public DatabaseAccountListKeysResult listKeys(String groupName, String accountName) {
        return (DatabaseAccountListKeysResult)this.listKeysAsync(groupName, accountName).block();
    }

    @Override
    public DatabaseAccountListReadOnlyKeysResult listReadOnlyKeys(String groupName, String accountName) {
        return (DatabaseAccountListReadOnlyKeysResult)this.listReadOnlyKeysAsync(groupName, accountName).block();
    }

    @Override
    public Mono<DatabaseAccountListKeysResult> listKeysAsync(String groupName, String accountName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listKeysAsync(groupName, accountName).map(databaseAccountListKeysResultInner -> new DatabaseAccountListKeysResultImpl((DatabaseAccountListKeysResultInner)databaseAccountListKeysResultInner));
    }

    @Override
    public Mono<DatabaseAccountListReadOnlyKeysResult> listReadOnlyKeysAsync(String groupName, String accountName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listReadOnlyKeysAsync(groupName, accountName).map(databaseAccountListReadOnlyKeysResultInner -> new DatabaseAccountListReadOnlyKeysResultImpl((DatabaseAccountListReadOnlyKeysResultInner)databaseAccountListReadOnlyKeysResultInner));
    }

    @Override
    public DatabaseAccountListConnectionStringsResult listConnectionStrings(String groupName, String accountName) {
        return (DatabaseAccountListConnectionStringsResult)this.listConnectionStringsAsync(groupName, accountName).block();
    }

    @Override
    public Mono<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync(String groupName, String accountName) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().listConnectionStringsAsync(groupName, accountName).map(databaseAccountListConnectionStringsResultInner -> new DatabaseAccountListConnectionStringsResultImpl((DatabaseAccountListConnectionStringsResultInner)databaseAccountListConnectionStringsResultInner));
    }

    @Override
    public void regenerateKey(String groupName, String accountName, KeyKind keyKind) {
        this.regenerateKeyAsync(groupName, accountName, keyKind).block();
    }

    @Override
    public Mono<Void> regenerateKeyAsync(String groupName, String accountName, KeyKind keyKind) {
        return ((CosmosDBManagementClient)((CosmosManager)this.manager()).serviceClient()).getDatabaseAccounts().regenerateKeyAsync(groupName, accountName, new DatabaseAccountRegenerateKeyParameters().withKeyKind(keyKind));
    }
}

