/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.NotebookWorkspacesClient;
import com.azure.resourcemanager.cosmos.fluent.models.NotebookWorkspaceConnectionInfoResultInner;
import com.azure.resourcemanager.cosmos.fluent.models.NotebookWorkspaceInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.NotebookWorkspaceListResult;
import com.azure.resourcemanager.cosmos.models.NotebookWorkspaceName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NotebookWorkspacesClientImpl
implements NotebookWorkspacesClient {
    private final ClientLogger logger = new ClientLogger(NotebookWorkspacesClientImpl.class);
    private final NotebookWorkspacesService service;
    private final CosmosDBManagementClientImpl client;

    NotebookWorkspacesClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (NotebookWorkspacesService)RestProxy.create(NotebookWorkspacesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<NotebookWorkspaceInner>> listByDatabaseAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listByDatabaseAccount(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookWorkspaceListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<NotebookWorkspaceInner>> listByDatabaseAccountSinglePageAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listByDatabaseAccount(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookWorkspaceListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<NotebookWorkspaceInner> listByDatabaseAccountAsync(String resourceGroupName, String accountName) {
        return new PagedFlux(() -> this.listByDatabaseAccountSinglePageAsync(resourceGroupName, accountName));
    }

    private PagedFlux<NotebookWorkspaceInner> listByDatabaseAccountAsync(String resourceGroupName, String accountName, Context context) {
        return new PagedFlux(() -> this.listByDatabaseAccountSinglePageAsync(resourceGroupName, accountName, context));
    }

    @Override
    public PagedIterable<NotebookWorkspaceInner> listByDatabaseAccount(String resourceGroupName, String accountName) {
        return new PagedIterable(this.listByDatabaseAccountAsync(resourceGroupName, accountName));
    }

    @Override
    public PagedIterable<NotebookWorkspaceInner> listByDatabaseAccount(String resourceGroupName, String accountName, Context context) {
        return new PagedIterable(this.listByDatabaseAccountAsync(resourceGroupName, accountName, context));
    }

    @Override
    public Mono<Response<NotebookWorkspaceInner>> getWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<NotebookWorkspaceInner>> getWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, context);
    }

    @Override
    public Mono<NotebookWorkspaceInner> getAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((NotebookWorkspaceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public NotebookWorkspaceInner get(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return (NotebookWorkspaceInner)((Object)this.getAsync(resourceGroupName, accountName, notebookWorkspaceName).block());
    }

    @Override
    public Response<NotebookWorkspaceInner> getWithResponse(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        if (notebookCreateUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookCreateUpdateParameters is required and cannot be null."));
        }
        notebookCreateUpdateParameters.validate();
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, notebookCreateUpdateParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        if (notebookCreateUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookCreateUpdateParameters is required and cannot be null."));
        }
        notebookCreateUpdateParameters.validate();
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, notebookCreateUpdateParameters, context);
    }

    @Override
    public PollerFlux<PollResult<NotebookWorkspaceInner>, NotebookWorkspaceInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName, notebookCreateUpdateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)NotebookWorkspaceInner.class), (Type)((Object)NotebookWorkspaceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<NotebookWorkspaceInner>, NotebookWorkspaceInner> beginCreateOrUpdateAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName, notebookCreateUpdateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)NotebookWorkspaceInner.class), (Type)((Object)NotebookWorkspaceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<NotebookWorkspaceInner>, NotebookWorkspaceInner> beginCreateOrUpdate(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, accountName, notebookWorkspaceName, notebookCreateUpdateParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<NotebookWorkspaceInner>, NotebookWorkspaceInner> beginCreateOrUpdate(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, accountName, notebookWorkspaceName, notebookCreateUpdateParameters, context).getSyncPoller();
    }

    @Override
    public Mono<NotebookWorkspaceInner> createOrUpdateAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, accountName, notebookWorkspaceName, notebookCreateUpdateParameters).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<NotebookWorkspaceInner> createOrUpdateAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, accountName, notebookWorkspaceName, notebookCreateUpdateParameters, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public NotebookWorkspaceInner createOrUpdate(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters) {
        return (NotebookWorkspaceInner)((Object)this.createOrUpdateAsync(resourceGroupName, accountName, notebookWorkspaceName, notebookCreateUpdateParameters).block());
    }

    @Override
    public NotebookWorkspaceInner createOrUpdate(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, ArmProxyResource notebookCreateUpdateParameters, Context context) {
        return (NotebookWorkspaceInner)((Object)this.createOrUpdateAsync(resourceGroupName, accountName, notebookWorkspaceName, notebookCreateUpdateParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return this.beginDeleteAsync(resourceGroupName, accountName, notebookWorkspaceName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, accountName, notebookWorkspaceName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return this.beginDeleteAsync(resourceGroupName, accountName, notebookWorkspaceName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, accountName, notebookWorkspaceName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        this.deleteAsync(resourceGroupName, accountName, notebookWorkspaceName).block();
    }

    @Override
    public void delete(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        this.deleteAsync(resourceGroupName, accountName, notebookWorkspaceName, context).block();
    }

    @Override
    public Mono<Response<NotebookWorkspaceConnectionInfoResultInner>> listConnectionInfoWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.listConnectionInfo(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<NotebookWorkspaceConnectionInfoResultInner>> listConnectionInfoWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.listConnectionInfo(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, context);
    }

    @Override
    public Mono<NotebookWorkspaceConnectionInfoResultInner> listConnectionInfoAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return this.listConnectionInfoWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((NotebookWorkspaceConnectionInfoResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public NotebookWorkspaceConnectionInfoResultInner listConnectionInfo(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return (NotebookWorkspaceConnectionInfoResultInner)this.listConnectionInfoAsync(resourceGroupName, accountName, notebookWorkspaceName).block();
    }

    @Override
    public Response<NotebookWorkspaceConnectionInfoResultInner> listConnectionInfoWithResponse(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        return (Response)this.listConnectionInfoWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> regenerateAuthTokenWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.regenerateAuthToken(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> regenerateAuthTokenWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.regenerateAuthToken(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginRegenerateAuthTokenAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.regenerateAuthTokenWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginRegenerateAuthTokenAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.regenerateAuthTokenWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRegenerateAuthToken(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return this.beginRegenerateAuthTokenAsync(resourceGroupName, accountName, notebookWorkspaceName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRegenerateAuthToken(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        return this.beginRegenerateAuthTokenAsync(resourceGroupName, accountName, notebookWorkspaceName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> regenerateAuthTokenAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return this.beginRegenerateAuthTokenAsync(resourceGroupName, accountName, notebookWorkspaceName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> regenerateAuthTokenAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        return this.beginRegenerateAuthTokenAsync(resourceGroupName, accountName, notebookWorkspaceName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void regenerateAuthToken(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        this.regenerateAuthTokenAsync(resourceGroupName, accountName, notebookWorkspaceName).block();
    }

    @Override
    public void regenerateAuthToken(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        this.regenerateAuthTokenAsync(resourceGroupName, accountName, notebookWorkspaceName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (notebookWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notebookWorkspaceName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-08-01", accountName, notebookWorkspaceName, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, accountName, notebookWorkspaceName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return this.beginStartAsync(resourceGroupName, accountName, notebookWorkspaceName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        return this.beginStartAsync(resourceGroupName, accountName, notebookWorkspaceName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> startAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        return this.beginStartAsync(resourceGroupName, accountName, notebookWorkspaceName).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> startAsync(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        return this.beginStartAsync(resourceGroupName, accountName, notebookWorkspaceName, context).last().flatMap(arg_0 -> ((CosmosDBManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void start(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName) {
        this.startAsync(resourceGroupName, accountName, notebookWorkspaceName).block();
    }

    @Override
    public void start(String resourceGroupName, String accountName, NotebookWorkspaceName notebookWorkspaceName, Context context) {
        this.startAsync(resourceGroupName, accountName, notebookWorkspaceName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    private static interface NotebookWorkspacesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/notebookWorkspaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NotebookWorkspaceListResult>> listByDatabaseAccount(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="accountName") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/notebookWorkspaces/{notebookWorkspaceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NotebookWorkspaceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="accountName") String var5, @PathParam(value="notebookWorkspaceName") NotebookWorkspaceName var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/notebookWorkspaces/{notebookWorkspaceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="accountName") String var5, @PathParam(value="notebookWorkspaceName") NotebookWorkspaceName var6, @BodyParam(value="application/json") ArmProxyResource var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/notebookWorkspaces/{notebookWorkspaceName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="accountName") String var5, @PathParam(value="notebookWorkspaceName") NotebookWorkspaceName var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/notebookWorkspaces/{notebookWorkspaceName}/listConnectionInfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NotebookWorkspaceConnectionInfoResultInner>> listConnectionInfo(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="accountName") String var5, @PathParam(value="notebookWorkspaceName") NotebookWorkspaceName var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/notebookWorkspaces/{notebookWorkspaceName}/regenerateAuthToken")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> regenerateAuthToken(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="accountName") String var5, @PathParam(value="notebookWorkspaceName") NotebookWorkspaceName var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/notebookWorkspaces/{notebookWorkspaceName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="accountName") String var5, @PathParam(value="notebookWorkspaceName") NotebookWorkspaceName var6, Context var7);
    }
}

