/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class DatabaseAccountUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DatabaseAccountUpdateParameters.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="properties.consistencyPolicy")
    private ConsistencyPolicy consistencyPolicy;
    @JsonProperty(value="properties.locations")
    private List<Location> locations;
    @JsonProperty(value="properties.ipRangeFilter")
    private String ipRangeFilter;
    @JsonProperty(value="properties.isVirtualNetworkFilterEnabled")
    private Boolean isVirtualNetworkFilterEnabled;
    @JsonProperty(value="properties.enableAutomaticFailover")
    private Boolean enableAutomaticFailover;
    @JsonProperty(value="properties.capabilities")
    private List<Capability> capabilities;
    @JsonProperty(value="properties.virtualNetworkRules")
    private List<VirtualNetworkRule> virtualNetworkRules;
    @JsonProperty(value="properties.enableMultipleWriteLocations")
    private Boolean enableMultipleWriteLocations;
    @JsonProperty(value="properties.enableCassandraConnector")
    private Boolean enableCassandraConnector;
    @JsonProperty(value="properties.connectorOffer")
    private ConnectorOffer connectorOffer;
    @JsonProperty(value="properties.disableKeyBasedMetadataWriteAccess")
    private Boolean disableKeyBasedMetadataWriteAccess;

    public Map<String, String> tags() {
        return this.tags;
    }

    public DatabaseAccountUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public DatabaseAccountUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public ConsistencyPolicy consistencyPolicy() {
        return this.consistencyPolicy;
    }

    public DatabaseAccountUpdateParameters withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    public List<Location> locations() {
        return this.locations;
    }

    public DatabaseAccountUpdateParameters withLocations(List<Location> locations) {
        this.locations = locations;
        return this;
    }

    public String ipRangeFilter() {
        return this.ipRangeFilter;
    }

    public DatabaseAccountUpdateParameters withIpRangeFilter(String ipRangeFilter) {
        this.ipRangeFilter = ipRangeFilter;
        return this;
    }

    public Boolean isVirtualNetworkFilterEnabled() {
        return this.isVirtualNetworkFilterEnabled;
    }

    public DatabaseAccountUpdateParameters withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        this.isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
        return this;
    }

    public Boolean enableAutomaticFailover() {
        return this.enableAutomaticFailover;
    }

    public DatabaseAccountUpdateParameters withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        this.enableAutomaticFailover = enableAutomaticFailover;
        return this;
    }

    public List<Capability> capabilities() {
        return this.capabilities;
    }

    public DatabaseAccountUpdateParameters withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public DatabaseAccountUpdateParameters withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public Boolean enableMultipleWriteLocations() {
        return this.enableMultipleWriteLocations;
    }

    public DatabaseAccountUpdateParameters withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        this.enableMultipleWriteLocations = enableMultipleWriteLocations;
        return this;
    }

    public Boolean enableCassandraConnector() {
        return this.enableCassandraConnector;
    }

    public DatabaseAccountUpdateParameters withEnableCassandraConnector(Boolean enableCassandraConnector) {
        this.enableCassandraConnector = enableCassandraConnector;
        return this;
    }

    public ConnectorOffer connectorOffer() {
        return this.connectorOffer;
    }

    public DatabaseAccountUpdateParameters withConnectorOffer(ConnectorOffer connectorOffer) {
        this.connectorOffer = connectorOffer;
        return this;
    }

    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.disableKeyBasedMetadataWriteAccess;
    }

    public DatabaseAccountUpdateParameters withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        this.disableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess;
        return this;
    }

    public void validate() {
        if (this.consistencyPolicy() != null) {
            this.consistencyPolicy().validate();
        }
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
    }
}

